/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.UUID;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class InventoryOpen
implements Listener {
    private final ToolStats toolStats;

    public InventoryOpen(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Inventory inventory = event.getInventory();
        Player player = (Player)event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        for (ItemStack itemStack : inventory) {
            ItemMeta itemMeta;
            if (itemStack == null || !this.toolStats.itemChecker.isValidItem(itemStack.getType()) || (itemMeta = itemStack.getItemMeta()) == null) continue;
            PersistentDataContainer container = itemMeta.getPersistentDataContainer();
            if (this.toolStats.config.getBoolean("tokens.enabled") && this.toolStats.itemChecker.keyCheck(container) && !container.has(this.toolStats.toolStatsKeys.getTokenType())) {
                String newTokens = this.toolStats.itemChecker.addTokensToExisting(itemStack);
                if (newTokens == null) {
                    return;
                }
                container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)newTokens);
                itemStack.setItemMeta(itemMeta);
            }
            if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
                Long timestamp;
                if (container.has(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING)) continue;
                UUID owner = null;
                if (container.has(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) {
                    owner = (UUID)container.get(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType());
                }
                if (owner == null) {
                    owner = player.getUniqueId();
                }
                if ((timestamp = (Long)container.get(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG)) == null) {
                    timestamp = System.currentTimeMillis();
                }
                String hash = this.toolStats.hashMaker.makeHash(itemStack.getType(), owner, timestamp);
                container.set(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING, (Object)hash);
                itemStack.setItemMeta(itemMeta);
                continue;
            }
            if (!container.has(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING)) continue;
            container.remove(this.toolStats.toolStatsKeys.getHash());
            itemStack.setItemMeta(itemMeta);
        }
    }
}

