/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryClose
implements Listener {
    private final ToolStats toolStats;

    public InventoryClose(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (this.toolStats.generateLoot.generatedInventory.isEmpty()) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        Inventory closedInventory = event.getInventory();
        InventoryHolder holder = closedInventory.getHolder();
        if (this.toolStats.generateLoot.generatedInventory.containsKey(closedInventory)) {
            Location chestLocation = this.toolStats.generateLoot.generatedInventory.get(closedInventory);
            this.toolStats.generateLoot.generatedInventory.remove(closedInventory);
            player.getScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> {
                PlayerInventory playerInventory = player.getInventory();
                for (int i = 0; i < playerInventory.getContents().length; ++i) {
                    ItemStack newItem;
                    ItemStack item = playerInventory.getItem(i);
                    if (item == null || !this.toolStats.itemChecker.isValidItem(item.getType()) || (newItem = this.addLootedOrigin(item, player)) == null) continue;
                    playerInventory.setItem(i, newItem);
                }
            }, null, 1L);
            if (holder instanceof StorageMinecart) {
                StorageMinecart mineCart = (StorageMinecart)holder;
                mineCart.getScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> {
                    Inventory chestInventory = mineCart.getInventory();
                    for (int i = 0; i < chestInventory.getContents().length; ++i) {
                        ItemStack newItem;
                        ItemStack item = chestInventory.getItem(i);
                        if (item == null || !this.toolStats.itemChecker.isValidItem(item.getType()) || (newItem = this.addLootedOrigin(item, player)) == null) continue;
                        chestInventory.setItem(i, newItem);
                    }
                }, null, 1L);
            }
            if (holder instanceof Container) {
                Container container = (Container)holder;
                Chunk chestChunk = chestLocation.getChunk();
                Bukkit.getRegionScheduler().runDelayed((Plugin)this.toolStats, chestLocation.getWorld(), chestChunk.getX(), chestChunk.getZ(), scheduledTask -> {
                    BlockState blockState = chestLocation.getWorld().getBlockAt(chestLocation).getState();
                    if (blockState instanceof InventoryHolder) {
                        InventoryHolder chest = (InventoryHolder)blockState;
                        Inventory chestInventory = chest.getInventory();
                        for (int i = 0; i < chestInventory.getContents().length; ++i) {
                            ItemStack newItem;
                            ItemStack item = chestInventory.getItem(i);
                            if (item == null || !this.toolStats.itemChecker.isValidItem(item.getType()) || (newItem = this.addLootedOrigin(item, player)) == null) continue;
                            chestInventory.setItem(i, newItem);
                        }
                    }
                }, 1L);
            }
        }
    }

    public ItemStack addLootedOrigin(ItemStack itemStack, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newItem = itemStack.clone();
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER) || container.has(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG) || container.has(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 2, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)2);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 2, newItem)) != null) {
            container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)2);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING, (Object)hash);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }
}

