/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class GenerateLoot
implements Listener {
    private final ToolStats toolStats;
    public Map<Inventory, Location> generatedInventory = new HashMap<Inventory, Location>();
    public List<Location> droppedLootLocations = new ArrayList<Location>();

    public GenerateLoot(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGenerateLoot(LootGenerateEvent event) {
        InventoryHolder inventoryHolder = event.getInventoryHolder();
        if (inventoryHolder == null) {
            return;
        }
        Location lootLocation = event.getLootContext().getLocation();
        if (!this.toolStats.configTools.checkWorld(lootLocation.getWorld().getName())) {
            return;
        }
        Chunk lootChunk = lootLocation.getChunk();
        Bukkit.getRegionScheduler().runDelayed((Plugin)this.toolStats, lootLocation.getWorld(), lootChunk.getX(), lootChunk.getZ(), scheduledTask -> {
            StorageMinecart mineCart;
            if (inventoryHolder instanceof Container) {
                Block openedChest = null;
                Location chestLocation = null;
                for (Block chest : this.toolStats.playerInteract.openedChests) {
                    double distance;
                    chestLocation = chest.getLocation();
                    if (chest.getWorld() != lootLocation.getWorld() || !((distance = lootLocation.distance(chestLocation)) <= 1.0)) continue;
                    openedChest = chest;
                }
                for (Block brokenChest : this.toolStats.blockBreak.brokenContainers) {
                    double distance;
                    Location brokenChestLocation = brokenChest.getLocation();
                    if (brokenChestLocation.getWorld() != lootLocation.getWorld() || !((distance = lootLocation.distance(brokenChestLocation)) <= 1.0)) continue;
                    this.droppedLootLocations.add(brokenChestLocation);
                    Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask2 -> this.droppedLootLocations.remove(brokenChestLocation), 20L);
                }
                if (openedChest != null) {
                    this.generatedInventory.put(inventoryHolder.getInventory(), chestLocation);
                }
            }
            if (inventoryHolder instanceof StorageMinecart && this.toolStats.playerInteract.openedMineCarts.contains(mineCart = (StorageMinecart)inventoryHolder)) {
                Inventory mineCartInventory = mineCart.getInventory();
                this.generatedInventory.put(mineCartInventory, mineCart.getLocation());
            }
        }, 1L);
    }
}

