/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class CreativeEvent
implements Listener {
    private final ToolStats toolStats;

    public CreativeEvent(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler
    public void onCreativeEvent(InventoryCreativeEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        ItemStack spawnedItem = event.getCursor();
        if (!this.toolStats.itemChecker.isValidItem(spawnedItem.getType())) {
            return;
        }
        ItemMeta spawnedItemMeta = spawnedItem.getItemMeta();
        if (spawnedItemMeta == null) {
            return;
        }
        PersistentDataContainer container = spawnedItemMeta.getPersistentDataContainer();
        if (container.has(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER)) {
            return;
        }
        ItemStack newItem = this.addCreativeOrigin(spawnedItem, player);
        if (newItem != null) {
            event.setCursor(newItem);
        }
    }

    private ItemStack addCreativeOrigin(ItemStack itemStack, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newSpawnedItem = itemStack.clone();
        ItemMeta meta = newSpawnedItem.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)itemStack);
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG) || container.has(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 6, newSpawnedItem);
        if (creationDate != null) {
            container.set(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)6);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 6, newSpawnedItem)) != null) {
            container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)6);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newSpawnedItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING, (Object)hash);
        }
        newSpawnedItem.setItemMeta(meta);
        return newSpawnedItem;
    }
}

