/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class BlockDispenseEvent
implements Listener {
    private final ToolStats toolStats;

    public BlockDispenseEvent(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDispense(BlockDispenseLootEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        List loot = event.getDispensedLoot();
        if (loot.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        for (ItemStack lootItem : loot) {
            ItemStack newLootItem = lootItem.clone();
            Material lootItemMaterial = newLootItem.getType();
            if (this.toolStats.itemChecker.isValidItem(lootItemMaterial)) {
                newLootItem = this.addLootedOrigin(newLootItem, player);
            }
            newLoot.add(Objects.requireNonNullElse(newLootItem, lootItem));
        }
        event.setDispensedLoot(newLoot);
    }

    private ItemStack addLootedOrigin(ItemStack itemStack, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newItem = itemStack.clone();
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG) || container.has(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 2, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)2);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 2, newItem)) != null) {
            container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER, (Object)2);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.toolStatsKeys.getHash(), PersistentDataType.STRING, (Object)hash);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }
}

