/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BlockBreak
implements Listener {
    private final ToolStats toolStats;
    public List<Block> brokenContainers = new ArrayList<Block>();

    public BlockBreak(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack heldItem = inventory.getItemInMainHand();
        Block block = event.getBlock();
        if (block.getType() == Material.CHEST || block.getType() == Material.BARREL) {
            this.brokenContainers.add(block);
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> this.brokenContainers.remove(block), 20L);
        }
        if (!this.toolStats.itemChecker.isMineTool(heldItem.getType())) {
            return;
        }
        if (heldItem.getType().toString().toLowerCase(Locale.ROOT).contains("hoe")) {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Ageable) {
                Ageable ageable = (Ageable)blockData;
                if (ageable.getAge() != ageable.getMaximumAge()) {
                    return;
                }
                newMeta = this.toolStats.itemLore.updateCropsMined(heldItem, 1);
                if (newMeta != null) {
                    heldItem.setItemMeta(newMeta);
                }
            } else {
                newMeta = this.toolStats.itemLore.updateBlocksMined(heldItem, 1);
                if (newMeta != null) {
                    heldItem.setItemMeta(newMeta);
                }
            }
        } else {
            ItemMeta newMeta = this.toolStats.itemLore.updateBlocksMined(heldItem, 1);
            if (newMeta != null) {
                heldItem.setItemMeta(newMeta);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreak(BlockDropItemEvent event) {
        Player player = event.getPlayer();
        if (!this.toolStats.configTools.checkWorld(player.getWorld().getName())) {
            return;
        }
        Location eventLocation = event.getBlock().getLocation();
        Chunk eventChunk = eventLocation.getChunk();
        Bukkit.getRegionScheduler().runDelayed((Plugin)this.toolStats, eventLocation.getWorld(), eventChunk.getX(), eventChunk.getZ(), scheduledTask -> {
            boolean validLootDrops = false;
            for (Location droppedLootLocation : this.toolStats.generateLoot.droppedLootLocations) {
                double distance;
                if (eventLocation.getWorld() != droppedLootLocation.getWorld() || !((distance = droppedLootLocation.distance(eventLocation)) <= 1.0)) continue;
                validLootDrops = true;
            }
            if (validLootDrops) {
                this.toolStats.generateLoot.droppedLootLocations.remove(eventLocation);
                for (Item droppedItemEntity : event.getItems()) {
                    ItemStack newItem;
                    ItemStack droppedItem = droppedItemEntity.getItemStack();
                    if (!this.toolStats.itemChecker.isValidItem(droppedItem.getType()) || (newItem = this.toolStats.inventoryClose.addLootedOrigin(droppedItem, player)) == null) continue;
                    droppedItemEntity.setItemStack(newItem);
                }
            }
        }, 1L);
    }
}

