/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.Locale;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class AnvilEvent
implements Listener {
    private final ToolStats toolStats;

    public AnvilEvent(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAnvilEvent(PrepareAnvilEvent event) {
        if (!this.toolStats.config.getBoolean("tokens.enabled")) {
            return;
        }
        AnvilInventory inventory = event.getInventory();
        ItemStack firstSlot = inventory.getItem(0);
        ItemStack secondSlot = inventory.getItem(1);
        if (firstSlot == null || secondSlot == null) {
            return;
        }
        Material firstSlotMaterial = firstSlot.getType();
        if (!this.toolStats.itemChecker.isValidItem(firstSlotMaterial)) {
            return;
        }
        PersistentDataContainer secondSlotContainer = secondSlot.getItemMeta().getPersistentDataContainer();
        if (!secondSlotContainer.has(this.toolStats.toolStatsKeys.getTokenType(), PersistentDataType.STRING)) {
            return;
        }
        String tokenType = (String)secondSlotContainer.get(this.toolStats.toolStatsKeys.getTokenType(), PersistentDataType.STRING);
        if (tokenType == null) {
            return;
        }
        if (secondSlot.getAmount() > 1) {
            return;
        }
        ItemStack clone = firstSlot.clone();
        if (tokenType.equalsIgnoreCase("reset")) {
            this.reset(event, clone);
            return;
        }
        if (tokenType.equalsIgnoreCase("remove")) {
            ItemStack removedStats = this.toolStats.itemLore.removeAll(clone, false);
            event.setResult(removedStats);
            event.getView().setRepairCost(this.toolStats.itemChecker.getCost("remove"));
            return;
        }
        if (this.toolStats.itemChecker.isMineTool(firstSlotMaterial)) {
            if (firstSlotMaterial.toString().toLowerCase(Locale.ROOT).contains("hoe")) {
                if (tokenType.equalsIgnoreCase("blocks-mined")) {
                    this.addToken(event, tokenType, "blocks-mined", clone);
                }
                if (tokenType.equalsIgnoreCase("crops-mined")) {
                    this.addToken(event, tokenType, "crops-mined", clone);
                }
            } else {
                if (firstSlotMaterial == Material.SHEARS && tokenType.equals("sheep-sheared")) {
                    this.addToken(event, tokenType, "sheep-sheared", clone);
                    return;
                }
                this.addToken(event, tokenType, "blocks-mined", clone);
            }
            if (firstSlotMaterial.toString().toLowerCase(Locale.ROOT).contains("_axe")) {
                if (tokenType.equalsIgnoreCase("player-kills")) {
                    this.addToken(event, tokenType, "player-kills", clone);
                    return;
                }
                if (tokenType.equalsIgnoreCase("mob-kills")) {
                    this.addToken(event, tokenType, "mob-kills", clone);
                    return;
                }
                if (tokenType.equalsIgnoreCase("damage-done")) {
                    this.addToken(event, tokenType, "damage-done", clone);
                    return;
                }
                if (tokenType.equalsIgnoreCase("wither-kills")) {
                    this.addToken(event, tokenType, "wither-kills", clone);
                    return;
                }
                if (tokenType.equalsIgnoreCase("enderdragon-kills")) {
                    this.addToken(event, tokenType, "enderdragon-kills", clone);
                    return;
                }
                if (tokenType.equalsIgnoreCase("critical-strikes")) {
                    this.addToken(event, tokenType, "critical-strikes", clone);
                    return;
                }
            }
            return;
        }
        if (this.toolStats.itemChecker.canGlide(clone)) {
            this.addToken(event, tokenType, "flight-time", clone);
            return;
        }
        if (this.toolStats.itemChecker.isArmor(firstSlotMaterial)) {
            this.addToken(event, tokenType, "damage-taken", clone);
            return;
        }
        if (this.toolStats.itemChecker.isMeleeWeapon(firstSlotMaterial)) {
            if (tokenType.equalsIgnoreCase("player-kills")) {
                this.addToken(event, tokenType, "player-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("mob-kills")) {
                this.addToken(event, tokenType, "mob-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("damage-done")) {
                this.addToken(event, tokenType, "damage-done", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("wither-kills")) {
                this.addToken(event, tokenType, "wither-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("enderdragon-kills")) {
                this.addToken(event, tokenType, "enderdragon-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("critical-strikes")) {
                this.addToken(event, tokenType, "critical-strikes", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("trident-throws")) {
                this.addToken(event, tokenType, "trident-throws", clone);
                return;
            }
            return;
        }
        if (firstSlotMaterial == Material.BOW || firstSlotMaterial == Material.CROSSBOW) {
            if (tokenType.equalsIgnoreCase("player-kills")) {
                this.addToken(event, tokenType, "player-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("mob-kills")) {
                this.addToken(event, tokenType, "mob-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("arrows-shot")) {
                this.addToken(event, tokenType, "arrows-shot", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("damage-done")) {
                this.addToken(event, tokenType, "damage-done", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("wither-kills")) {
                this.addToken(event, tokenType, "wither-kills", clone);
                return;
            }
            if (tokenType.equalsIgnoreCase("enderdragon-kills")) {
                this.addToken(event, tokenType, "enderdragon-kills", clone);
                return;
            }
            return;
        }
        if (firstSlotMaterial == Material.FISHING_ROD) {
            this.addToken(event, tokenType, "fish-caught", clone);
        }
    }

    private void addToken(PrepareAnvilEvent event, String attemptToken, String targetToken, ItemStack firstSlotItem) {
        if (!attemptToken.equalsIgnoreCase(targetToken)) {
            event.setResult(null);
            return;
        }
        if (this.toolStats.itemChecker.checkTokens(firstSlotItem.getItemMeta().getPersistentDataContainer(), targetToken)) {
            event.setResult(null);
            return;
        }
        ItemStack newItem = this.toolStats.itemChecker.addToken(firstSlotItem, targetToken);
        switch (targetToken) {
            case "crops-mined": {
                if (this.toolStats.config.getBoolean("enabled.crops-harvested")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateCropsMined(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "blocks-mined": {
                if (this.toolStats.configTools.checkConfig(newItem.getType(), "blocks-mined")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateBlocksMined(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "damage-taken": {
                if (this.toolStats.config.getBoolean("enabled.armor-damage")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateArmorDamage(newItem, 0.0, false));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "damage-done": {
                if (this.toolStats.configTools.checkConfig(newItem.getType(), "damage-done")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateWeaponDamage(newItem, 0.0, false));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "mob-kills": {
                if (this.toolStats.configTools.checkConfig(newItem.getType(), "mob-kills")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateMobKills(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "player-kills": {
                if (this.toolStats.configTools.checkConfig(newItem.getType(), "player-kills")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updatePlayerKills(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "arrows-shot": {
                if (this.toolStats.config.getBoolean("enabled.arrows-shot")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateArrowsShot(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "sheep-sheared": {
                if (this.toolStats.config.getBoolean("enabled.sheep-sheared")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateSheepSheared(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "flight-time": {
                if (this.toolStats.config.getBoolean("enabled.flight-time")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateFlightTime(newItem, 0L));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "fish-caught": {
                if (this.toolStats.config.getBoolean("enabled.fish-caught")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateFishCaught(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "wither-kills": {
                if (this.toolStats.config.getBoolean("enabled.bosses-killed.wither")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateBossesKilled(newItem, 0, "wither"));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "enderdragon-kills": {
                if (this.toolStats.config.getBoolean("enabled.bosses-killed.enderdragon")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateBossesKilled(newItem, 0, "enderdragon"));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "critical-strikes": {
                if (this.toolStats.config.getBoolean("enabled.critical-strikes")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateCriticalStrikes(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
            case "trident-throws": {
                if (this.toolStats.config.getBoolean("enabled.trident-throws")) {
                    newItem.setItemMeta(this.toolStats.itemLore.updateTridentThrows(newItem, 0));
                    break;
                }
                event.setResult(null);
                return;
            }
        }
        event.setResult(newItem);
        event.getView().setRepairCost(this.toolStats.itemChecker.getCost(targetToken));
    }

    private void reset(PrepareAnvilEvent event, ItemStack inputItem) {
        ItemStack finalItem = inputItem.clone();
        ItemMeta meta = finalItem.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.toolStats.toolStatsKeys.getPlayerKills())) {
            Integer playerKills = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER);
            if (playerKills == null) {
                return;
            }
            meta = this.toolStats.itemLore.updatePlayerKills(finalItem, -playerKills.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getMobKills())) {
            Integer mobKills = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER);
            if (mobKills == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateMobKills(finalItem, -mobKills.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getBlocksMined())) {
            Integer blocksMined = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER);
            if (blocksMined == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateBlocksMined(finalItem, -blocksMined.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested())) {
            Integer cropsHarvested = (Integer)container.get(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER);
            if (cropsHarvested == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateCropsMined(finalItem, -cropsHarvested.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getFishCaught())) {
            Integer fishCaught = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER);
            if (fishCaught == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateFishCaught(finalItem, -fishCaught.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getSheepSheared())) {
            Integer sheepSheared = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER);
            if (sheepSheared == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateSheepSheared(finalItem, -sheepSheared.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getArmorDamage())) {
            Double armorDamage = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE);
            if (armorDamage == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateArmorDamage(finalItem, -armorDamage.doubleValue(), true);
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getDamageDone())) {
            Double damageDone = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE);
            if (damageDone == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateArmorDamage(finalItem, -damageDone.doubleValue(), true);
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getArrowsShot())) {
            Integer arrowsShot = (Integer)container.get(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER);
            if (arrowsShot == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateArrowsShot(finalItem, -arrowsShot.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getFlightTime())) {
            Long flightTime = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG);
            if (flightTime == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateFlightTime(finalItem, -flightTime.longValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getWitherKills())) {
            Integer witherKills = (Integer)container.get(this.toolStats.toolStatsKeys.getWitherKills(), PersistentDataType.INTEGER);
            if (witherKills == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateBossesKilled(finalItem, -witherKills.intValue(), "wither");
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getEnderDragonKills())) {
            Integer enderDragonKills = (Integer)container.get(this.toolStats.toolStatsKeys.getEnderDragonKills(), PersistentDataType.INTEGER);
            if (enderDragonKills == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateBossesKilled(finalItem, -enderDragonKills.intValue(), "enderdragon");
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes())) {
            Integer criticalStrikes = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER);
            if (criticalStrikes == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateCriticalStrikes(finalItem, -criticalStrikes.intValue());
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.toolStatsKeys.getTridentThrows())) {
            Integer tridentThrows = (Integer)container.get(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER);
            if (tridentThrows == null) {
                return;
            }
            meta = this.toolStats.itemLore.updateTridentThrows(finalItem, -tridentThrows.intValue());
            finalItem.setItemMeta(meta);
        }
        event.setResult(finalItem);
        event.getView().setRepairCost(this.toolStats.itemChecker.getCost("reset"));
    }
}

