/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandToolStats
implements TabExecutor {
    private final ToolStats toolStats;

    public CommandToolStats(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.hasPermission("toolstats.command")) {
            sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)("ToolStats version " + this.toolStats.getPluginMeta().getVersion() + ". Created by hyperdefined."), (TextColor)NamedTextColor.GREEN));
            return true;
        }
        switch (args[0]) {
            case "reload": {
                if (sender.hasPermission("toolstats.reload")) {
                    boolean oldTokensStatus = this.toolStats.tokens;
                    this.toolStats.loadConfig();
                    this.toolStats.tokenData.getRecipes().clear();
                    this.toolStats.tokenData.setup();
                    if (this.toolStats.tokens != oldTokensStatus) {
                        if (this.toolStats.tokens) {
                            sender.sendMessage((Component)Component.text((String)"It looks like you ENABLED the token system. While this is fine, it can break. Please restart your server instead.", (TextColor)NamedTextColor.YELLOW));
                            if (this.toolStats.config.getBoolean("tokens.craft-token")) {
                                for (ShapedRecipe recipe : this.toolStats.tokenData.getRecipes()) {
                                    Bukkit.addRecipe((Recipe)recipe);
                                }
                            }
                        } else {
                            sender.sendMessage((Component)Component.text((String)"It looks like you DISABLED the token system. While this is fine, it can break. Please restart your server instead.", (TextColor)NamedTextColor.YELLOW));
                            for (ShapedRecipe recipe : this.toolStats.tokenData.getRecipes()) {
                                Bukkit.removeRecipe((NamespacedKey)recipe.getKey());
                            }
                        }
                    }
                    sender.sendMessage((Component)Component.text((String)"Configuration reloaded!", (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "edit": {
                if (!sender.hasPermission("toolstats.edit")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage((Component)Component.text((String)"Invalid syntax. Usage: /toolstats edit <stat> <value>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.handleEdit(args[1], args[2], (Player)sender);
                return true;
            }
            case "remove": {
                if (!sender.hasPermission("toolstats.remove")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Invalid syntax. Usage: /toolstats remove <stat>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.handleRemove(args[1], (Player)sender);
                return true;
            }
            case "reset": {
                if (!sender.hasPermission("toolstats.reset")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length == 2 && args[1].equalsIgnoreCase("confirm")) {
                    if (!sender.hasPermission("toolstats.reset.confirm")) {
                        sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Player player = (Player)sender;
                    ItemStack heldItem = player.getInventory().getItemInMainHand();
                    if (!this.toolStats.itemChecker.isValidItem(heldItem.getType())) {
                        sender.sendMessage((Component)Component.text((String)"You must hold a valid item.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    this.fixItemLore(heldItem, player);
                    sender.sendMessage((Component)Component.text((String)"The lore was reset!", (TextColor)NamedTextColor.GREEN));
                    return true;
                }
                sender.sendMessage((Component)Component.text((String)"This will remove ALL current lore from the held item and replace it with the correct lore.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"If the owner of the item is broken, it will reset to the person holding it.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"Only use this if the tags on the tool are incorrect.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"Type /toolstats reset confirm to confirm this.", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "purge": {
                if (!sender.hasPermission("toolstats.purge")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    sender.sendMessage((Component)Component.text((String)"You must be a player for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length == 2 && args[1].equalsIgnoreCase("confirm")) {
                    if (!sender.hasPermission("toolstats.purge.confirm")) {
                        sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Player player = (Player)sender;
                    ItemStack heldItem = player.getInventory().getItemInMainHand();
                    if (!this.toolStats.itemChecker.isValidItem(heldItem.getType())) {
                        sender.sendMessage((Component)Component.text((String)"You must hold a valid item.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    ItemStack purgedItem = this.toolStats.itemLore.removeAll(heldItem, true);
                    player.getInventory().setItemInMainHand(purgedItem);
                    sender.sendMessage((Component)Component.text((String)"The item was purged!", (TextColor)NamedTextColor.GREEN));
                    return true;
                }
                sender.sendMessage((Component)Component.text((String)"This will purge ALL ToolStats data from this item.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"This includes all stats, ownership, and creation time.", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"THIS CANNOT BE UNDONE!", (TextColor)NamedTextColor.GREEN));
                sender.sendMessage((Component)Component.text((String)"Type /toolstats purge confirm to confirm this.", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "givetokens": {
                if (!sender.hasPermission("toolstats.givetokens")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage((Component)Component.text((String)"Invalid syntax. Usage: /toolstats givetokens <player> <token>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player target = Bukkit.getPlayerExact((String)args[1]);
                if (target == null) {
                    sender.sendMessage((Component)Component.text((String)"Player not found.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                String tokenType = args[2];
                if (!this.toolStats.tokenData.getTokenTypes().contains(tokenType)) {
                    sender.sendMessage((Component)Component.text((String)"Invalid token type.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (!this.toolStats.config.getBoolean("tokens.enabled")) {
                    sender.sendMessage((Component)Component.text((String)"Unable to give tokens. Tokens are disabled", (TextColor)NamedTextColor.RED));
                    return true;
                }
                int amount = 1;
                if (args.length >= 4) {
                    try {
                        amount = Integer.parseInt(args[3]);
                        if (amount <= 0) {
                            sender.sendMessage((Component)Component.text((String)"Token quantity must be above or 1.", (TextColor)NamedTextColor.RED));
                            return true;
                        }
                    }
                    catch (NumberFormatException exception) {
                        sender.sendMessage((Component)Component.text((String)"Invalid token quantity.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                }
                this.giveToken(target, tokenType, amount);
                if (sender instanceof Player) {
                    sender.sendMessage((Component)Component.text((String)("Gave " + target.getName() + " " + amount + " " + tokenType + " tokens."), (TextColor)NamedTextColor.GREEN));
                }
                return true;
            }
        }
        sender.sendMessage((Component)Component.text((String)"Invalid sub-command.", (TextColor)NamedTextColor.RED));
        return true;
    }

    private void fixItemLore(ItemStack original, Player player) {
        Integer tridentThrows;
        Integer strikes;
        Integer arrows;
        Double damage;
        Integer sheep;
        Integer fish;
        Integer kills;
        Long flightTime;
        Component creationTimeLore;
        Long time;
        ItemStack finalItem = original.clone();
        ItemMeta finalMeta = finalItem.getItemMeta();
        if (finalMeta == null) {
            return;
        }
        PersistentDataContainer container = finalMeta.getPersistentDataContainer();
        ArrayList<Component> lore = new ArrayList<Component>();
        Integer origin = -1;
        if (container.has(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER)) {
            origin = (Integer)container.get(this.toolStats.toolStatsKeys.getOriginType(), PersistentDataType.INTEGER);
        }
        if (origin == null) {
            origin = -1;
        }
        if (container.has(this.toolStats.toolStatsKeys.getDroppedBy(), PersistentDataType.STRING) && this.toolStats.config.getBoolean("enabled.dropped-by")) {
            if (container.has(this.toolStats.toolStatsKeys.getDroppedBy())) {
                String droppedBy = (String)container.get(this.toolStats.toolStatsKeys.getDroppedBy(), PersistentDataType.STRING);
                lore.add(this.toolStats.configTools.formatLore("dropped-by", "{name}", droppedBy));
            } else {
                player.sendMessage((Component)Component.text((String)"Unable to set 'dropped-by', as this item has no record of it."));
            }
        }
        if (container.has(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType())) {
            Component ownerLore;
            UUID owner = (UUID)container.get(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType());
            String ownerName = null;
            if (owner != null) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)owner);
                ownerName = offlinePlayer.getName();
            }
            if (ownerName == null) {
                player.sendMessage((Component)Component.text((String)("The owner of this item is null. Setting to " + player.getName() + "."), (TextColor)NamedTextColor.RED));
                ownerName = player.getName();
                container.set(this.toolStats.toolStatsKeys.getItemOwner(), (PersistentDataType)new UUIDDataType(), (Object)player.getUniqueId());
            }
            if ((ownerLore = this.toolStats.itemLore.formatOwner(ownerName, origin, original)) != null) {
                lore.add(ownerLore);
            }
        }
        if (container.has(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG) && (time = (Long)container.get(this.toolStats.toolStatsKeys.getTimeCreated(), PersistentDataType.LONG)) != null && (creationTimeLore = this.toolStats.itemLore.formatCreationTime(time, origin, original)) != null) {
            lore.add(creationTimeLore);
        }
        if (this.toolStats.config.getBoolean("enabled.flight-time") && container.has(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG) && (flightTime = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG)) != null) {
            Map<String, String> flightTimeFormatted = this.toolStats.numberFormat.formatTime(flightTime);
            Component line = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", flightTimeFormatted);
            lore.add(line);
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "player-kills") && container.has(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER) && (kills = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("kills.player", "{kills}", this.toolStats.numberFormat.formatInt(kills)));
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "mob-kills") && container.has(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER) && (kills = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("kills.mob", "{kills}", this.toolStats.numberFormat.formatInt(kills)));
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "blocks-mined")) {
            Integer blocksMined;
            Integer crops;
            if (original.getType().toString().toLowerCase(Locale.ROOT).contains("hoe") && container.has(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER) && (crops = (Integer)container.get(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER)) != null) {
                lore.add(this.toolStats.configTools.formatLore("crops-harvested", "{crops}", this.toolStats.numberFormat.formatInt(crops)));
            }
            if (container.has(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER) && (blocksMined = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER)) != null) {
                lore.add(this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", this.toolStats.numberFormat.formatInt(blocksMined)));
            }
        }
        if (this.toolStats.config.getBoolean("enabled.fish-caught") && container.has(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER) && (fish = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", this.toolStats.numberFormat.formatInt(fish)));
        }
        if (this.toolStats.config.getBoolean("enabled.sheep-sheared") && container.has(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER) && (sheep = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", this.toolStats.numberFormat.formatInt(sheep)));
        }
        if (this.toolStats.config.getBoolean("enabled.armor-damage") && container.has(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE) && (damage = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE)) != null) {
            lore.add(this.toolStats.configTools.formatLore("damage-taken", "{damage}", this.toolStats.numberFormat.formatDouble(damage)));
        }
        if (this.toolStats.configTools.checkConfig(original.getType(), "damage-done") && container.has(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE) && (damage = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE)) != null) {
            lore.add(this.toolStats.configTools.formatLore("damage-done", "{damage}", this.toolStats.numberFormat.formatDouble(damage)));
        }
        if (this.toolStats.config.getBoolean("enabled.arrows-shot") && container.has(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER) && (arrows = (Integer)container.get(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", this.toolStats.numberFormat.formatInt(arrows)));
        }
        if (this.toolStats.config.getBoolean("enabled.bosses-killed.wither") && container.has(this.toolStats.toolStatsKeys.getWitherKills(), PersistentDataType.INTEGER) && (kills = (Integer)container.get(this.toolStats.toolStatsKeys.getWitherKills(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("bosses-killed.wither", "{kills}", this.toolStats.numberFormat.formatInt(kills)));
        }
        if (this.toolStats.config.getBoolean("enabled.bosses-killed.enderdragon") && container.has(this.toolStats.toolStatsKeys.getEnderDragonKills(), PersistentDataType.INTEGER) && (kills = (Integer)container.get(this.toolStats.toolStatsKeys.getEnderDragonKills(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("bosses-killed.enderdragon", "{kills}", this.toolStats.numberFormat.formatInt(kills)));
        }
        if (this.toolStats.config.getBoolean("enabled.critical-strikes") && container.has(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER) && (strikes = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("critical-strikes", "{strikes}", this.toolStats.numberFormat.formatInt(strikes)));
        }
        if (this.toolStats.config.getBoolean("enabled.trident-throws") && container.has(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER) && (tridentThrows = (Integer)container.get(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER)) != null) {
            lore.add(this.toolStats.configTools.formatLore("trident-throws", "{times}", this.toolStats.numberFormat.formatInt(tridentThrows)));
        }
        finalMeta.lore(lore);
        finalItem.setItemMeta(finalMeta);
        int slot = player.getInventory().getHeldItemSlot();
        player.getInventory().setItem(slot, finalItem);
    }

    private void giveToken(Player target, String tokenType, int amount) {
        ItemStack token = this.toolStats.tokenData.createToken(tokenType);
        token.setAmount(amount);
        target.getInventory().addItem(new ItemStack[]{token});
    }

    private void handleEdit(String stat, Object userValue, Player player) {
        ItemStack editedItem = player.getInventory().getItemInMainHand().clone();
        if (!this.toolStats.itemChecker.isValidItem(editedItem.getType())) {
            player.sendMessage((Component)Component.text((String)"This is not a valid item.", (TextColor)NamedTextColor.RED));
            return;
        }
        ItemMeta editedItemMeta = editedItem.getItemMeta();
        PersistentDataContainer container = editedItemMeta.getPersistentDataContainer();
        switch (stat) {
            case "crops-harvested": {
                if (!this.toolStats.config.getBoolean("enabled.crops-harvested")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateCropsMined(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "blocks-mined": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "blocks-mined")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getBlocksMined())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateBlocksMined(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-taken": {
                if (!this.toolStats.config.getBoolean("enabled.armor-damage")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getArmorDamage())) {
                    double value;
                    try {
                        value = Double.parseDouble((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0.0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Double statValue = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    double difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateArmorDamage(editedItem, difference, false);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-done": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "damage-done")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getDamageDone())) {
                    double value;
                    try {
                        value = Double.parseDouble((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0.0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Double statValue = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    double difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateWeaponDamage(editedItem, difference, false);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "mob-kills": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "mob-kills")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getMobKills())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateMobKills(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "player-kills": {
                if (!this.toolStats.configTools.checkConfig(editedItem.getType(), "player-kills")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getPlayerKills())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updatePlayerKills(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "arrows-shot": {
                if (!this.toolStats.config.getBoolean("enabled.arrows-shot")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getArrowsShot())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getArrowsShot(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateArrowsShot(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "sheep-sheared": {
                if (!this.toolStats.config.getBoolean("enabled.sheep-sheared")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getSheepSheared())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateSheepSheared(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "flight-time": {
                if (!this.toolStats.config.getBoolean("enabled.flight-time")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getFlightTime())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Long statValue = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    long difference = (long)value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateFlightTime(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "fight-caught": {
                if (!this.toolStats.config.getBoolean("enabled.fight-caught")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getFishCaught())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateFishCaught(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "wither-kills": {
                if (!this.toolStats.config.getBoolean("enabled.bosses-killed.wither")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getWitherKills())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getWitherKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateBossesKilled(editedItem, difference, "wither");
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "enderdragon-kills": {
                if (!this.toolStats.config.getBoolean("enabled.bosses-killed.enderdragon")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getEnderDragonKills())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getEnderDragonKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateBossesKilled(editedItem, difference, "enderdragon");
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "critical-strikes": {
                if (!this.toolStats.config.getBoolean("enabled.critical-strikes")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateCriticalStrikes(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "trident-throws": {
                if (!this.toolStats.config.getBoolean("enabled.trident-throws")) {
                    player.sendMessage((Component)Component.text((String)"This stat is disabled.", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (container.has(this.toolStats.toolStatsKeys.getTridentThrows())) {
                    int value;
                    try {
                        value = Integer.parseInt((String)userValue);
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage((Component)Component.text((String)"That is not a valid number.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    if (value < 0) {
                        player.sendMessage((Component)Component.text((String)"Number must be positive.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    int difference = value - statValue;
                    editedItemMeta = this.toolStats.itemLore.updateTridentThrows(editedItem, difference);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            default: {
                player.sendMessage((Component)Component.text((String)"That is not a valid stat to update.", (TextColor)NamedTextColor.RED));
                return;
            }
        }
        editedItem.setItemMeta(editedItemMeta);
        player.getInventory().setItemInMainHand(editedItem);
        player.sendMessage((Component)Component.text((String)("Updated stat " + stat + " for held item!"), (TextColor)NamedTextColor.GREEN));
    }

    private void handleRemove(String stat, Player player) {
        ItemStack editedItem = player.getInventory().getItemInMainHand().clone();
        if (!this.toolStats.itemChecker.isValidItem(editedItem.getType())) {
            player.sendMessage((Component)Component.text((String)"This is not a valid item.", (TextColor)NamedTextColor.RED));
            return;
        }
        ItemMeta editedItemMeta = editedItem.getItemMeta();
        PersistentDataContainer container = editedItemMeta.getPersistentDataContainer();
        switch (stat) {
            case "crops-harvested": {
                if (container.has(this.toolStats.toolStatsKeys.getCropsHarvested())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getCropsHarvested(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getCropsHarvested());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "crops-mined");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "blocks-mined": {
                if (container.has(this.toolStats.toolStatsKeys.getBlocksMined())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getBlocksMined(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getBlocksMined());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "blocks-mined");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-taken": {
                if (container.has(this.toolStats.toolStatsKeys.getArmorDamage())) {
                    Double statValue = (Double)container.get(this.toolStats.toolStatsKeys.getArmorDamage(), PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getArmorDamage());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "damage-taken");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("damage-taken", "{damage}", this.toolStats.numberFormat.formatDouble(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "damage-done": {
                if (container.has(this.toolStats.toolStatsKeys.getDamageDone())) {
                    Double statValue = (Double)container.get(this.toolStats.toolStatsKeys.getDamageDone(), PersistentDataType.DOUBLE);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getDamageDone());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "damage-done");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("damage-done", "{damage}", this.toolStats.numberFormat.formatDouble(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "mob-kills": {
                if (container.has(this.toolStats.toolStatsKeys.getMobKills())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getMobKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getMobKills());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "mob-kills");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("kills.mob", "{kills}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "player-kills": {
                if (container.has(this.toolStats.toolStatsKeys.getPlayerKills())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getPlayerKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getPlayerKills());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "player-kills");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("kills.player", "{kills}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "sheep-sheared": {
                if (container.has(this.toolStats.toolStatsKeys.getSheepSheared())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getSheepSheared(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getSheepSheared());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "sheep-sheared");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "flight-time": {
                if (container.has(this.toolStats.toolStatsKeys.getFlightTime())) {
                    Long statValue = (Long)container.get(this.toolStats.toolStatsKeys.getFlightTime(), PersistentDataType.LONG);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getFlightTime());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "flight-time");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Map<String, String> timeFormatted = this.toolStats.numberFormat.formatTime(statValue);
                    Component oldLine = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", timeFormatted);
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "fight-caught": {
                if (container.has(this.toolStats.toolStatsKeys.getFishCaught())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getFishCaught(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getFishCaught());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "fight-caught");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "wither-kills": {
                if (container.has(this.toolStats.toolStatsKeys.getWitherKills())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getWitherKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getWitherKills());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "wither-kills");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("bosses-killed.wither", "{kills}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "enderdragon-kills": {
                if (container.has(this.toolStats.toolStatsKeys.getEnderDragonKills())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getEnderDragonKills(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getEnderDragonKills());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "enderdragon-kills");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("bosses-killed.enderdragon", "{kills}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "critical-strikes": {
                if (container.has(this.toolStats.toolStatsKeys.getCriticalStrikes())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getCriticalStrikes(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getCriticalStrikes());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "critical-strikes");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("critical-strikes", "{strikes}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "trident-throws": {
                if (container.has(this.toolStats.toolStatsKeys.getTridentThrows())) {
                    Integer statValue = (Integer)container.get(this.toolStats.toolStatsKeys.getTridentThrows(), PersistentDataType.INTEGER);
                    if (statValue == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get stat from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    String tokens = (String)container.get(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING);
                    if (tokens == null) {
                        player.sendMessage((Component)Component.text((String)"Unable to get tokens from item.", (TextColor)NamedTextColor.RED));
                        return;
                    }
                    container.remove(this.toolStats.toolStatsKeys.getTridentThrows());
                    List<String> newTokens = this.toolStats.itemChecker.removeToken(tokens, "trident-throws");
                    if (newTokens.isEmpty()) {
                        container.remove(this.toolStats.toolStatsKeys.getTokenApplied());
                    } else {
                        container.set(this.toolStats.toolStatsKeys.getTokenApplied(), PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens));
                    }
                    Component oldLine = this.toolStats.configTools.formatLore("trident-throws", "{times}", this.toolStats.numberFormat.formatInt(statValue));
                    List<Component> newLore = this.toolStats.itemLore.removeLore(editedItemMeta.lore(), oldLine);
                    editedItemMeta.lore(newLore);
                    break;
                }
                player.sendMessage((Component)Component.text((String)"This item does not have that stat.", (TextColor)NamedTextColor.RED));
                break;
            }
            default: {
                player.sendMessage((Component)Component.text((String)"That is not a valid stat to update.", (TextColor)NamedTextColor.RED));
                return;
            }
        }
        editedItem.setItemMeta(editedItemMeta);
        player.getInventory().setItemInMainHand(editedItem);
        player.sendMessage((Component)Component.text((String)("Removed stat " + stat + " for held item!"), (TextColor)NamedTextColor.GREEN));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (sender.hasPermission("toolstats.reload")) {
                suggestions.add("reload");
            }
            if (sender.hasPermission("toolstats.reset")) {
                suggestions.add("reset");
            }
            if (sender.hasPermission("toolstats.givetokens")) {
                suggestions.add("givetokens");
            }
            if (sender.hasPermission("toolstats.edit")) {
                suggestions.add("edit");
            }
            if (sender.hasPermission("toolstats.remove")) {
                suggestions.add("remove");
            }
            if (sender.hasPermission("toolstats.purge")) {
                suggestions.add("purge");
            }
            return suggestions.isEmpty() ? null : suggestions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("reset") && sender.hasPermission("toolstats.reset.confirm")) {
            return Collections.singletonList("confirm");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("purge") && sender.hasPermission("toolstats.purge.confirm")) {
            return Collections.singletonList("confirm");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("edit") && sender.hasPermission("toolstats.edit")) {
            return this.toolStats.tokenData.getTokenTypes().stream().filter(s -> !s.equals("remove") && !s.equals("reset")).map(s -> s.equals("crops-mined") ? "crops-harvested" : s).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove") && sender.hasPermission("toolstats.remove")) {
            return this.toolStats.tokenData.getTokenTypes().stream().filter(s -> !s.equals("remove") && !s.equals("reset")).map(s -> s.equals("crops-mined") ? "crops-harvested" : s).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("givetokens") && sender.hasPermission("toolstats.givetokens")) {
            return this.toolStats.tokenData.getTokenTypes();
        }
        return null;
    }
}

