/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools.config.versions;

import java.io.File;
import java.io.IOException;
import lol.hyper.toolstats.ToolStats;

public class Version13 {
    private final ToolStats toolStats;

    public Version13(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public void update() {
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config-12.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config-12.yml!", (Throwable)exception);
        }
        this.toolStats.logger.info("Updating config.yml to version 13.");
        this.toolStats.config.set("config-version", (Object)13);
        for (String key : this.toolStats.config.getConfigurationSection("tokens.data").getKeys(false)) {
            this.toolStats.logger.info("Adding tokens.data.{}.material", (Object)key);
            this.toolStats.config.set("tokens.data." + key + ".material", (Object)"PAPER");
            this.toolStats.logger.info("Adding tokens.data.{}.custom-model-data.enabled", (Object)key);
            this.toolStats.config.set("tokens.data." + key + ".custom-model-data.enabled", (Object)false);
            this.toolStats.logger.info("Adding tokens.data.{}.custom-model-data.type", (Object)key);
            this.toolStats.config.set("tokens.data." + key + ".custom-model-data.type", (Object)"float");
            this.toolStats.logger.info("Adding tokens.data.{}.custom-model-data.value", (Object)key);
            this.toolStats.config.set("tokens.data." + key + ".custom-model-data.value", (Object)1001);
        }
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config.yml!", (Throwable)exception);
        }
        this.toolStats.loadConfig();
        this.toolStats.logger.info("Config has been updated to version 13. A copy of version 12 has been saved as config-12.yml");
    }
}

