/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools.config.versions;

import java.io.File;
import java.io.IOException;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.configuration.ConfigurationSection;

public class Version12 {
    private final ToolStats toolStats;

    public Version12(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public void update() {
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config-11.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config-11.yml!", (Throwable)exception);
        }
        this.toolStats.logger.info("Updating config.yml to version 12.");
        this.toolStats.config.set("config-version", (Object)12);
        this.transfer("enabled.created-by", "enabled.crafted-by");
        this.transfer("enabled.created-date", "enabled.crafted-on");
        this.transfer("enabled.fished-tag", "enabled.fished-by");
        this.transfer("enabled.fished-tag", "enabled.fished-on");
        this.transfer("enabled.looted-tag", "enabled.looted-by");
        this.transfer("enabled.looted-tag", "enabled.looted-on");
        this.transfer("enabled.traded-tag", "enabled.traded-by");
        this.transfer("enabled.traded-tag", "enabled.traded-on");
        this.transfer("enabled.spawned-in", "enabled.spawned-in-by");
        this.transfer("enabled.spawned-in", "enabled.spawned-in-on");
        this.transfer("messages.created", "messages.crafted");
        this.toolStats.config.set("enabled.created-by", null);
        this.toolStats.config.set("enabled.created-date", null);
        this.toolStats.config.set("enabled.fished-tag", null);
        this.toolStats.config.set("enabled.looted-tag", null);
        this.toolStats.config.set("enabled.traded-tag", null);
        this.toolStats.config.set("enabled.spawned-in", null);
        this.toolStats.logger.info("Adding enabled.dropped-on");
        boolean droppedBy = this.toolStats.config.getBoolean("enabled.dropped-by");
        this.toolStats.config.set("enabled.dropped-on", (Object)droppedBy);
        this.toolStats.logger.info("Adding messages.dropped-on");
        this.toolStats.config.set("messages.dropped-on", (Object)"&7Dropped on: &8{date}");
        String craftedByMessage = this.toolStats.config.getString("messages.created.created-by");
        String craftedOnMessage = this.toolStats.config.getString("messages.created.created-on");
        this.toolStats.config.set("messages.created", null);
        this.toolStats.config.set("messages.crafted.created-by", null);
        this.toolStats.config.set("messages.crafted.created-on", null);
        this.toolStats.config.set("messages.crafted.crafted-by", (Object)craftedByMessage);
        this.toolStats.config.set("messages.crafted.crafted-on", (Object)craftedOnMessage);
        this.toolStats.logger.info("Adding normalize-time-creation");
        this.toolStats.config.set("normalize-time-creation", (Object)false);
        try {
            this.toolStats.config.save("plugins" + File.separator + "ToolStats" + File.separator + "config.yml");
        }
        catch (IOException exception) {
            this.toolStats.logger.error("Unable to save config.yml!", (Throwable)exception);
        }
        this.toolStats.loadConfig();
        this.toolStats.logger.info("Config has been updated to version 12. A copy of version 11 has been saved as config-11.yml");
    }

    private void transfer(String oldSection, String newSection) {
        this.toolStats.logger.info("Moving {} to {}", (Object)oldSection, (Object)newSection);
        ConfigurationSection old = this.toolStats.config.getConfigurationSection(oldSection);
        this.toolStats.config.set(newSection, (Object)old);
    }
}

