/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.hyper.toolstats.ToolStats;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;

public class ConfigTools {
    private final ToolStats toolStats;

    public ConfigTools(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public boolean checkConfig(Material material, String configName) {
        if (this.toolStats.config.getConfigurationSection("enabled." + configName) == null) {
            this.toolStats.logger.warn("Missing config section for enabled{}", (Object)configName);
            return false;
        }
        String itemName = material.toString().toLowerCase();
        String itemType = null;
        if (material == Material.BOW || material == Material.CROSSBOW || material == Material.SHEARS || material == Material.TRIDENT || material == Material.FISHING_ROD) {
            switch (material) {
                case CROSSBOW: 
                case BOW: {
                    itemType = "bow";
                    break;
                }
                case SHEARS: {
                    itemType = "shears";
                    break;
                }
                case TRIDENT: {
                    itemType = "trident";
                    break;
                }
                case FISHING_ROD: {
                    itemType = "fishing-rod";
                }
            }
        } else {
            itemType = itemName.substring(itemName.indexOf(95) + 1);
        }
        return switch (itemType) {
            case "pickaxe" -> this.toolStats.config.getBoolean("enabled." + configName + ".pickaxe");
            case "sword" -> this.toolStats.config.getBoolean("enabled." + configName + ".sword");
            case "shovel" -> this.toolStats.config.getBoolean("enabled." + configName + ".shovel");
            case "axe" -> this.toolStats.config.getBoolean("enabled." + configName + ".axe");
            case "hoe" -> this.toolStats.config.getBoolean("enabled." + configName + ".hoe");
            case "shears" -> this.toolStats.config.getBoolean("enabled." + configName + ".shears");
            case "crossbow", "bow" -> this.toolStats.config.getBoolean("enabled." + configName + ".bow");
            case "trident" -> this.toolStats.config.getBoolean("enabled." + configName + ".trident");
            case "fishing-rod" -> this.toolStats.config.getBoolean("enabled." + configName + ".fishing-rod");
            case "mace" -> this.toolStats.config.getBoolean("enabled." + configName + ".mace");
            case "spear" -> this.toolStats.config.getBoolean("enabled." + configName + ".spear");
            case "helmet", "chestplate", "leggings", "boots" -> this.toolStats.config.getBoolean("enabled." + configName + ".armor");
            default -> false;
        };
    }

    public Component formatLore(String configName, String placeHolder, Object value) {
        String lore = this.toolStats.config.getString("messages." + configName);
        if (lore == null) {
            this.toolStats.logger.warn("Unable to find config message for: messages.{}", (Object)configName);
            return null;
        }
        if (lore.isEmpty()) {
            return null;
        }
        if (placeHolder != null && value != null) {
            lore = lore.replace(placeHolder, String.valueOf(value));
        }
        Component component = this.toolStats.textUtils.format(lore);
        return component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public Component formatLoreMultiplePlaceholders(String configName, Map<String, String> placeHoldersValues) {
        String lore = this.toolStats.config.getString("messages." + configName);
        if (lore == null) {
            this.toolStats.logger.warn("Unable to find config message for: messages.{}", (Object)configName);
            return null;
        }
        if (lore.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\{([^}]+)\\}(\\S*)\\s*");
        Matcher matcher = pattern.matcher(lore);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            String placeholder = matcher.group(1);
            String unit = matcher.group(2);
            result.append(lore, lastEnd, matcher.start());
            if (placeHoldersValues.containsKey(placeholder)) {
                result.append(placeHoldersValues.get(placeholder)).append(unit).append(" ");
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < lore.length()) {
            result.append(lore.substring(lastEnd));
        }
        String outputText = result.toString().replaceAll("\\s+", " ").trim();
        Component component = this.toolStats.textUtils.format(outputText);
        return component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public List<Component> getTokenLore(String tokenType) {
        List raw = this.toolStats.config.getStringList("tokens.data." + tokenType + ".lore");
        if (raw.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> finalLore = new ArrayList<Component>();
        for (String line : raw) {
            Integer levels;
            if (line.contains("{levels}") && (levels = Integer.valueOf(this.toolStats.config.getInt("tokens.data." + tokenType + ".levels"))) != 0) {
                line = line.replace("{levels}", String.valueOf(levels));
            }
            Component component = this.toolStats.textUtils.format(line);
            component = component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
            finalLore.add(component);
        }
        return finalLore;
    }
}

