/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ItemLore {
    private final ToolStats toolStats;

    public ItemLore(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public List<Component> updateItemLore(ItemMeta itemMeta, Component oldLine, Component newLine) {
        ArrayList<Component> itemLore;
        if (itemMeta.hasLore()) {
            itemLore = itemMeta.lore();
            for (int x = 0; x < itemLore.size(); ++x) {
                String line = PlainTextComponentSerializer.plainText().serialize((Component)itemLore.get(x));
                if (!line.equals(PlainTextComponentSerializer.plainText().serialize(oldLine))) continue;
                itemLore.set(x, newLine);
                return itemLore;
            }
            itemLore.add(newLine);
        } else {
            itemLore = new ArrayList<Component>();
            itemLore.add(newLine);
        }
        return itemLore;
    }

    public List<Component> removeLore(List<Component> inputLore, Component toRemove) {
        if (inputLore == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> newLore = new ArrayList<Component>(inputLore);
        newLore.removeIf(line -> PlainTextComponentSerializer.plainText().serialize(line).equals(PlainTextComponentSerializer.plainText().serialize(toRemove)));
        return newLore;
    }

    public ItemMeta updateCropsMined(ItemStack playerTool, int add) {
        String newTokens;
        ItemStack clone = playerTool.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.crops-harvested")) {
            if (container.has(this.toolStats.cropsHarvested)) {
                String appliedTokens;
                Integer cropsMined = (Integer)container.get(this.toolStats.cropsHarvested, PersistentDataType.INTEGER);
                if (cropsMined == null) {
                    return null;
                }
                container.remove(this.toolStats.cropsHarvested);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "crops-mined");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldCropsMinedFormatted = this.toolStats.numberFormat.formatInt(cropsMined);
                    Component lineToRemove = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", oldCropsMinedFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "crops-mined");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.cropsHarvested) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer cropsMined = 0;
        if (container.has(this.toolStats.cropsHarvested, PersistentDataType.INTEGER)) {
            cropsMined = (Integer)container.get(this.toolStats.cropsHarvested, PersistentDataType.INTEGER);
        }
        if (cropsMined == null) {
            cropsMined = 0;
            this.toolStats.logger.warn("{} does not have valid crops-mined set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.cropsHarvested, PersistentDataType.INTEGER, (Object)(cropsMined + add));
        String oldCropsMinedFormatted = this.toolStats.numberFormat.formatInt(cropsMined);
        String newCropsMinedFormatted = this.toolStats.numberFormat.formatInt(cropsMined + add);
        Component oldLine = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", oldCropsMinedFormatted);
        Component newLine = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", newCropsMinedFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateBlocksMined(ItemStack playerTool, int add) {
        String newTokens;
        ItemStack clone = playerTool.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "blocks-mined")) {
            if (container.has(this.toolStats.blocksMined)) {
                String appliedTokens;
                Integer blocksMined = (Integer)container.get(this.toolStats.blocksMined, PersistentDataType.INTEGER);
                if (blocksMined == null) {
                    return null;
                }
                container.remove(this.toolStats.blocksMined);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "blocks-mined");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldBlocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined);
                    Component lineToRemove = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", oldBlocksMinedFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "blocks-mined");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.blocksMined) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer blocksMined = 0;
        if (container.has(this.toolStats.blocksMined, PersistentDataType.INTEGER)) {
            blocksMined = (Integer)container.get(this.toolStats.blocksMined, PersistentDataType.INTEGER);
        }
        if (blocksMined == null) {
            blocksMined = 0;
            this.toolStats.logger.warn("{} does not have valid generic-mined set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.blocksMined, PersistentDataType.INTEGER, (Object)(blocksMined + add));
        String oldBlocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined);
        String newBlocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined + add);
        Component oldLine = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", oldBlocksMinedFormatted);
        Component newLine = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", newBlocksMinedFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updatePlayerKills(ItemStack playerWeapon, int add) {
        String newTokens;
        ItemStack clone = playerWeapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "player-kills")) {
            if (container.has(this.toolStats.playerKills)) {
                String appliedTokens;
                Integer playerKills = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER);
                if (playerKills == null) {
                    return null;
                }
                container.remove(this.toolStats.playerKills);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "player-kills");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldPlayerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills);
                    Component lineToRemove = this.toolStats.configTools.formatLore("player-kills", "{kills}", oldPlayerKillsFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "player-kills");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.playerKills) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer playerKills = 0;
        if (container.has(this.toolStats.playerKills, PersistentDataType.INTEGER)) {
            playerKills = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER);
        }
        if (playerKills == null) {
            playerKills = 0;
            this.toolStats.logger.warn("{} does not have valid player-kills set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.playerKills, PersistentDataType.INTEGER, (Object)(playerKills + add));
        String oldPlayerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills);
        String newPlayerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills + add);
        Component oldLine = this.toolStats.configTools.formatLore("kills.player", "{kills}", oldPlayerKillsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("kills.player", "{kills}", newPlayerKillsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateMobKills(ItemStack playerWeapon, int add) {
        String newTokens;
        ItemStack clone = playerWeapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "mob-kills")) {
            if (container.has(this.toolStats.mobKills)) {
                String appliedTokens;
                Integer mobKills = (Integer)container.get(this.toolStats.mobKills, PersistentDataType.INTEGER);
                if (mobKills == null) {
                    return null;
                }
                container.remove(this.toolStats.mobKills);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "mob-kills");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldMobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills);
                    Component lineToRemove = this.toolStats.configTools.formatLore("mob-kills", "{kills}", oldMobKillsFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "mob-kills");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.mobKills) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer mobKills = 0;
        if (container.has(this.toolStats.mobKills, PersistentDataType.INTEGER)) {
            mobKills = (Integer)container.get(this.toolStats.mobKills, PersistentDataType.INTEGER);
        }
        if (mobKills == null) {
            mobKills = 0;
            this.toolStats.logger.warn("{} does not have valid mob-kills set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.mobKills, PersistentDataType.INTEGER, (Object)(mobKills + add));
        String oldMobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills);
        String newMobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills + add);
        Component oldLine = this.toolStats.configTools.formatLore("kills.mob", "{kills}", oldMobKillsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("kills.mob", "{kills}", newMobKillsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateArmorDamage(ItemStack armorPiece, double damage, boolean bypass) {
        String newTokens;
        if (damage < 0.0 && !bypass) {
            return null;
        }
        ItemStack clone = armorPiece.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.armor-damage")) {
            if (container.has(this.toolStats.armorDamage)) {
                String appliedTokens;
                Double armorDamage = (Double)container.get(this.toolStats.armorDamage, PersistentDataType.DOUBLE);
                if (armorDamage == null) {
                    return null;
                }
                container.remove(this.toolStats.armorDamage);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "damage-taken");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldDamageTakenFormatted = this.toolStats.numberFormat.formatDouble(armorDamage);
                    Component lineToRemove = this.toolStats.configTools.formatLore("damage-taken", "{damage}", oldDamageTakenFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "damage-taken");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.armorDamage) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Double damageTaken = 0.0;
        if (container.has(this.toolStats.armorDamage, PersistentDataType.DOUBLE)) {
            damageTaken = (Double)container.get(this.toolStats.armorDamage, PersistentDataType.DOUBLE);
        }
        if (damageTaken == null) {
            damageTaken = 0.0;
            this.toolStats.logger.warn("{} does not have valid damage-taken set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.armorDamage, PersistentDataType.DOUBLE, (Object)(damageTaken + damage));
        String oldDamageFormatted = this.toolStats.numberFormat.formatDouble(damageTaken);
        String newDamageFormatted = this.toolStats.numberFormat.formatDouble(damageTaken + damage);
        Component oldLine = this.toolStats.configTools.formatLore("damage-taken", "{damage}", oldDamageFormatted);
        Component newLine = this.toolStats.configTools.formatLore("damage-taken", "{damage}", newDamageFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateWeaponDamage(ItemStack weapon, double damage, boolean bypass) {
        String newTokens;
        if (damage < 0.0 && !bypass) {
            return null;
        }
        ItemStack clone = weapon.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.configTools.checkConfig(clone.getType(), "damage-done")) {
            if (container.has(this.toolStats.damageDone)) {
                String appliedTokens;
                Double damageDone = (Double)container.get(this.toolStats.damageDone, PersistentDataType.DOUBLE);
                if (damageDone == null) {
                    return null;
                }
                container.remove(this.toolStats.damageDone);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "damage-done");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldDamageDoneFormatted = this.toolStats.numberFormat.formatDouble(damageDone);
                    Component lineToRemove = this.toolStats.configTools.formatLore("damage-done", "{damage}", oldDamageDoneFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "damage-done");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.damageDone) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Double damageDone = 0.0;
        if (container.has(this.toolStats.damageDone, PersistentDataType.DOUBLE)) {
            damageDone = (Double)container.get(this.toolStats.damageDone, PersistentDataType.DOUBLE);
        }
        if (damageDone == null) {
            damageDone = 0.0;
            this.toolStats.logger.warn("{} does not have valid damage-done set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.damageDone, PersistentDataType.DOUBLE, (Object)(damageDone + damage));
        String oldDamageFormatted = this.toolStats.numberFormat.formatDouble(damageDone);
        String newDamageFormatted = this.toolStats.numberFormat.formatDouble(damageDone + damage);
        Component oldLine = this.toolStats.configTools.formatLore("damage-done", "{damage}", oldDamageFormatted);
        Component newLine = this.toolStats.configTools.formatLore("damage-done", "{damage}", newDamageFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateFlightTime(ItemStack elytra, long duration) {
        String newTokens;
        ItemStack clone = elytra.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.flight-time")) {
            if (container.has(this.toolStats.flightTime)) {
                String appliedTokens;
                Long flightTime = (Long)container.get(this.toolStats.flightTime, PersistentDataType.LONG);
                if (flightTime == null) {
                    return null;
                }
                container.remove(this.toolStats.flightTime);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "flight-time");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    List<Component> newLore;
                    if (this.toolStats.config.getString("messages.flight-time-old") != null) {
                        String oldFormatFormatted = this.toolStats.numberFormat.formatDouble((double)flightTime.longValue() / 1000.0);
                        Component oldFormat = this.toolStats.configTools.formatLore("flight-time-old", "{time}", oldFormatFormatted);
                        newLore = this.removeLore(meta.lore(), oldFormat);
                        meta.lore(newLore);
                    }
                    Map<String, String> oldFlightTimeFormatted = this.toolStats.numberFormat.formatTime(flightTime);
                    Component lineToRemove = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", oldFlightTimeFormatted);
                    newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "flight-time");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.flightTime) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Long flightTime = 0L;
        if (container.has(this.toolStats.flightTime, PersistentDataType.LONG)) {
            flightTime = (Long)container.get(this.toolStats.flightTime, PersistentDataType.LONG);
        }
        if (flightTime == null) {
            flightTime = 0L;
            this.toolStats.logger.warn("{} does not have valid flight-time set! Resting to zero. This should NEVER happen.", (Object)flightTime);
        }
        container.set(this.toolStats.flightTime, PersistentDataType.LONG, (Object)(flightTime + duration));
        Map<String, String> oldFlightFormatted = this.toolStats.numberFormat.formatTime(flightTime);
        Map<String, String> newFlightFormatted = this.toolStats.numberFormat.formatTime(flightTime + duration);
        if (this.toolStats.config.getString("messages.flight-time-old") != null && meta.hasLore()) {
            String oldFormatFormatted = this.toolStats.numberFormat.formatDouble((double)flightTime.longValue() / 1000.0);
            Component oldFormat = this.toolStats.configTools.formatLore("flight-time-old", "{time}", oldFormatFormatted);
            meta.lore(this.removeLore(meta.lore(), oldFormat));
        }
        Component oldLine = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", oldFlightFormatted);
        Component newLine = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", newFlightFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateSheepSheared(ItemStack shears, int add) {
        String newTokens;
        ItemStack clone = shears.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.sheep-sheared")) {
            if (container.has(this.toolStats.sheepSheared)) {
                String appliedTokens;
                Integer sheepSheared = (Integer)container.get(this.toolStats.sheepSheared, PersistentDataType.INTEGER);
                if (sheepSheared == null) {
                    return null;
                }
                container.remove(this.toolStats.sheepSheared);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "sheep-sheared");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldSheepShearedFormatted = this.toolStats.numberFormat.formatDouble(sheepSheared.intValue());
                    Component lineToRemove = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", oldSheepShearedFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "sheep-sheared");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.sheepSheared) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer sheepSheared = 0;
        if (container.has(this.toolStats.sheepSheared, PersistentDataType.INTEGER)) {
            sheepSheared = (Integer)container.get(this.toolStats.sheepSheared, PersistentDataType.INTEGER);
        }
        if (sheepSheared == null) {
            sheepSheared = 0;
            this.toolStats.logger.warn("{} does not have valid sheared set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.sheepSheared, PersistentDataType.INTEGER, (Object)(sheepSheared + add));
        String oldSheepFormatted = this.toolStats.numberFormat.formatInt(sheepSheared);
        String newSheepFormatted = this.toolStats.numberFormat.formatInt(sheepSheared + add);
        Component oldLine = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", oldSheepFormatted);
        Component newLine = this.toolStats.configTools.formatLore("sheep-sheared", "{sheep}", newSheepFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateArrowsShot(ItemStack bow, int add) {
        String newTokens;
        ItemStack clone = bow.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.arrows-shot")) {
            if (container.has(this.toolStats.arrowsShot)) {
                String appliedTokens;
                Integer arrowsShot = (Integer)container.get(this.toolStats.arrowsShot, PersistentDataType.INTEGER);
                if (arrowsShot == null) {
                    return null;
                }
                container.remove(this.toolStats.arrowsShot);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "arrows-shot");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldArrowsShotFormatted = this.toolStats.numberFormat.formatDouble(arrowsShot.intValue());
                    Component lineToRemove = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", oldArrowsShotFormatted);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "arrows-shot");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.arrowsShot) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer arrowsShot = 0;
        if (container.has(this.toolStats.arrowsShot, PersistentDataType.INTEGER)) {
            arrowsShot = (Integer)container.get(this.toolStats.arrowsShot, PersistentDataType.INTEGER);
        }
        if (arrowsShot == null) {
            arrowsShot = 0;
            this.toolStats.logger.warn("{} does not have valid arrows-shot set! Resting to zero. This should NEVER happen.", (Object)arrowsShot);
        }
        container.set(this.toolStats.arrowsShot, PersistentDataType.INTEGER, (Object)(arrowsShot + add));
        String oldArrowsFormatted = this.toolStats.numberFormat.formatInt(arrowsShot);
        String newArrowsFormatted = this.toolStats.numberFormat.formatInt(arrowsShot + add);
        Component oldLine = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", oldArrowsFormatted);
        Component newLine = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", newArrowsFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public ItemMeta updateFishCaught(ItemStack fishingRod, int add) {
        String newTokens;
        ItemStack clone = fishingRod.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)clone);
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!this.toolStats.config.getBoolean("enabled.fish-caught")) {
            if (container.has(this.toolStats.fishCaught)) {
                String appliedTokens;
                Integer fishCaught = (Integer)container.get(this.toolStats.fishCaught, PersistentDataType.INTEGER);
                if (fishCaught == null) {
                    return null;
                }
                container.remove(this.toolStats.fishCaught);
                if (container.has(this.toolStats.tokenApplied) && (appliedTokens = (String)container.get(this.toolStats.tokenApplied, PersistentDataType.STRING)) != null) {
                    List<String> newTokens2 = this.toolStats.itemChecker.removeToken(appliedTokens, "fish-caught");
                    if (!newTokens2.isEmpty()) {
                        container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)String.join((CharSequence)",", newTokens2));
                    } else {
                        container.remove(this.toolStats.tokenApplied);
                    }
                }
                if (meta.hasLore()) {
                    String oldFishCaught = this.toolStats.numberFormat.formatDouble(fishCaught.intValue());
                    Component lineToRemove = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", oldFishCaught);
                    List<Component> newLore = this.removeLore(meta.lore(), lineToRemove);
                    meta.lore(newLore);
                }
                return meta;
            }
            return null;
        }
        boolean validToken = this.toolStats.itemChecker.checkTokens(container, "fish-caught");
        if (this.toolStats.config.getBoolean("tokens.enabled")) {
            if (container.has(this.toolStats.fishCaught) && !validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
                container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
            }
            if (!validToken) {
                return null;
            }
        } else if (!validToken && (newTokens = this.toolStats.itemChecker.addTokensToExisting(clone)) != null) {
            container.set(this.toolStats.tokenApplied, PersistentDataType.STRING, (Object)newTokens);
        }
        Integer fishCaught = 0;
        if (container.has(this.toolStats.fishCaught, PersistentDataType.INTEGER)) {
            fishCaught = (Integer)container.get(this.toolStats.fishCaught, PersistentDataType.INTEGER);
        }
        if (fishCaught == null) {
            fishCaught = 0;
            this.toolStats.logger.warn("{} does not have valid fish-caught set! Resting to zero. This should NEVER happen.", (Object)clone);
        }
        container.set(this.toolStats.fishCaught, PersistentDataType.INTEGER, (Object)(fishCaught + add));
        String oldFishFormatted = this.toolStats.numberFormat.formatInt(fishCaught);
        String newFishFormatted = this.toolStats.numberFormat.formatInt(fishCaught + add);
        Component oldLine = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", oldFishFormatted);
        Component newLine = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", newFishFormatted);
        if (oldLine == null || newLine == null) {
            return null;
        }
        List<Component> newLore = this.updateItemLore(meta, oldLine, newLine);
        meta.lore(newLore);
        return meta;
    }

    public Component formatOwner(String playerName, int origin, ItemStack item) {
        switch (origin) {
            case 0: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "crafted-by")) break;
                return this.toolStats.configTools.formatLore("crafted.crafted-by", "{player}", playerName);
            }
            case 2: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "looted-by")) break;
                return this.toolStats.configTools.formatLore("looted.looted-by", "{player}", playerName);
            }
            case 3: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "traded-by")) break;
                return this.toolStats.configTools.formatLore("traded.traded-by", "{player}", playerName);
            }
            case 4: {
                if (!this.toolStats.config.getBoolean("enabled.elytra-tag")) break;
                return this.toolStats.configTools.formatLore("looted.found-by", "{player}", playerName);
            }
            case 5: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "fished-by")) break;
                return this.toolStats.configTools.formatLore("fished.caught-by", "{player}", playerName);
            }
            case 6: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "spawned-in-by")) break;
                return this.toolStats.configTools.formatLore("spawned-in.spawned-by", "{player}", playerName);
            }
        }
        return null;
    }

    public Component formatCreationTime(long creationDate, int origin, ItemStack item) {
        String date = this.toolStats.numberFormat.formatDate(new Date(creationDate));
        switch (origin) {
            case 0: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "crafted-on")) break;
                return this.toolStats.configTools.formatLore("crafted.crafted-on", "{date}", date);
            }
            case 1: {
                if (!this.toolStats.config.getBoolean("enabled.dropped-on")) break;
                return this.toolStats.configTools.formatLore("dropped-on", "{date}", date);
            }
            case 2: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "looted-on")) break;
                return this.toolStats.configTools.formatLore("looted.looted-on", "{date}", date);
            }
            case 3: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "traded-on")) break;
                return this.toolStats.configTools.formatLore("traded.traded-on", "{date}", date);
            }
            case 4: {
                if (!this.toolStats.config.getBoolean("enabled.elytra-tag")) break;
                return this.toolStats.configTools.formatLore("looted.found-on", "{date}", date);
            }
            case 5: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "fished-on")) break;
                return this.toolStats.configTools.formatLore("fished.caught-on", "{date}", date);
            }
            case 6: {
                if (!this.toolStats.configTools.checkConfig(item.getType(), "spawned-in-on")) break;
                return this.toolStats.configTools.formatLore("spawned-in.spawned-on", "{date}", date);
            }
        }
        return null;
    }

    public ItemStack removeAll(ItemStack inputItem, boolean removeMeta) {
        Long flightTime;
        Integer arrowsShot;
        Double damageDone;
        Double armorDamage;
        Integer sheepSheared;
        Integer fishCaught;
        Integer cropsHarvested;
        Integer blocksMined;
        Integer mobKills;
        Component lineToRemove;
        Integer playerKills;
        ItemStack finalItem = inputItem.clone();
        ItemMeta meta = finalItem.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.toolStats.tokenApplied)) {
            container.remove(this.toolStats.tokenApplied);
        }
        if (container.has(this.toolStats.playerKills) && (playerKills = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.playerKills);
            String playerKillsFormatted = this.toolStats.numberFormat.formatInt(playerKills);
            lineToRemove = this.toolStats.configTools.formatLore("kills.player", "{kills}", playerKillsFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.mobKills) && (mobKills = (Integer)container.get(this.toolStats.mobKills, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.mobKills);
            String mobKillsFormatted = this.toolStats.numberFormat.formatInt(mobKills);
            lineToRemove = this.toolStats.configTools.formatLore("kills.mob", "{kills}", mobKillsFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.blocksMined) && (blocksMined = (Integer)container.get(this.toolStats.blocksMined, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.blocksMined);
            String blocksMinedFormatted = this.toolStats.numberFormat.formatInt(blocksMined);
            lineToRemove = this.toolStats.configTools.formatLore("blocks-mined", "{blocks}", blocksMinedFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.cropsHarvested) && (cropsHarvested = (Integer)container.get(this.toolStats.playerKills, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.cropsHarvested);
            String cropsHarvestedFormatted = this.toolStats.numberFormat.formatInt(cropsHarvested);
            lineToRemove = this.toolStats.configTools.formatLore("crops-harvested", "{crops}", cropsHarvestedFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.fishCaught) && (fishCaught = (Integer)container.get(this.toolStats.fishCaught, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.fishCaught);
            String fishCaughtFormatted = this.toolStats.numberFormat.formatInt(fishCaught);
            lineToRemove = this.toolStats.configTools.formatLore("fished.fish-caught", "{fish}", fishCaughtFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.sheepSheared) && (sheepSheared = (Integer)container.get(this.toolStats.sheepSheared, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.sheepSheared);
            String sheepShearedFormatted = this.toolStats.numberFormat.formatInt(sheepSheared);
            lineToRemove = this.toolStats.configTools.formatLore("sheep.sheared", "{sheep}", sheepShearedFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.armorDamage) && (armorDamage = (Double)container.get(this.toolStats.armorDamage, PersistentDataType.DOUBLE)) != null) {
            container.remove(this.toolStats.armorDamage);
            String armorDamageFormatted = this.toolStats.numberFormat.formatDouble(armorDamage);
            lineToRemove = this.toolStats.configTools.formatLore("damage-taken", "{damage}", armorDamageFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.damageDone) && (damageDone = (Double)container.get(this.toolStats.damageDone, PersistentDataType.DOUBLE)) != null) {
            container.remove(this.toolStats.damageDone);
            String damageDoneFormatted = this.toolStats.numberFormat.formatDouble(damageDone);
            lineToRemove = this.toolStats.configTools.formatLore("damage-done", "{damage}", damageDoneFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.arrowsShot) && (arrowsShot = (Integer)container.get(this.toolStats.arrowsShot, PersistentDataType.INTEGER)) != null) {
            container.remove(this.toolStats.arrowsShot);
            String arrowsShotFormatted = this.toolStats.numberFormat.formatInt(arrowsShot);
            lineToRemove = this.toolStats.configTools.formatLore("arrows-shot", "{arrows}", arrowsShotFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (container.has(this.toolStats.flightTime) && (flightTime = (Long)container.get(this.toolStats.flightTime, PersistentDataType.LONG)) != null) {
            container.remove(this.toolStats.flightTime);
            Map<String, String> flightTimeFormatted = this.toolStats.numberFormat.formatTime(flightTime);
            lineToRemove = this.toolStats.configTools.formatLoreMultiplePlaceholders("flight-time", flightTimeFormatted);
            meta.lore(this.removeLore(meta.lore(), lineToRemove));
            finalItem.setItemMeta(meta);
        }
        if (removeMeta) {
            UUID owner;
            Long timeCreated;
            Integer origin = null;
            if (container.has(this.toolStats.originType)) {
                origin = (Integer)container.get(this.toolStats.originType, PersistentDataType.INTEGER);
            }
            if (container.has(this.toolStats.timeCreated) && (timeCreated = (Long)container.get(this.toolStats.timeCreated, PersistentDataType.LONG)) != null && origin != null) {
                container.remove(this.toolStats.timeCreated);
                Component timeCreatedLore = this.formatCreationTime(timeCreated, origin, finalItem);
                meta.lore(this.removeLore(meta.lore(), timeCreatedLore));
            }
            if (container.has(this.toolStats.itemOwner) && (owner = (UUID)container.get(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType())) != null && origin != null) {
                container.remove(this.toolStats.itemOwner);
                String ownerName = Bukkit.getOfflinePlayer((UUID)owner).getName();
                if (ownerName != null) {
                    Component ownerLore = this.formatOwner(ownerName, origin, finalItem);
                    meta.lore(this.removeLore(meta.lore(), ownerLore));
                }
            }
            if (origin != null) {
                container.remove(this.toolStats.originType);
            }
            finalItem.setItemMeta(meta);
        }
        return finalItem;
    }
}

