/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.hyperlib.releases.modrinth;

import java.util.ArrayList;
import java.util.List;
import lol.hyper.toolstats.hyperlib.HyperLib;
import lol.hyper.toolstats.hyperlib.releases.modrinth.ModrinthDownload;
import lol.hyper.toolstats.hyperlib.releases.modrinth.ModrinthRelease;
import lol.hyper.toolstats.hyperlib.utils.JSONUtils;
import lol.hyper.toolstats.shaded.json.JSONArray;
import lol.hyper.toolstats.shaded.json.JSONObject;
import org.jetbrains.annotations.Nullable;

public class ModrinthPlugin {
    private final String projectID;
    private final List<ModrinthRelease> releases = new ArrayList<ModrinthRelease>();
    private String slug;
    private String type;
    private String latest;

    public ModrinthPlugin(String projectID) {
        this.projectID = projectID;
    }

    public void get() {
        String projectUrl = "https://api.modrinth.com/v2/project/" + this.projectID;
        JSONObject projectFetch = JSONUtils.requestJSONObject(projectUrl);
        if (projectFetch == null) {
            HyperLib.getPluginLogger().error("Unable to fetch plugin information from {}", (Object)projectUrl);
            return;
        }
        this.slug = projectFetch.getString("slug");
        this.type = projectFetch.getString("project_type");
        String versionsUrl = "https://api.modrinth.com/v2/project/" + this.projectID + "/version";
        JSONArray versionsFetch = JSONUtils.requestJSONArray(versionsUrl);
        if (versionsFetch == null) {
            HyperLib.getPluginLogger().error("Unable to fetch plugin information from {}", (Object)versionsUrl);
            return;
        }
        for (int i = 0; i < versionsFetch.length(); ++i) {
            JSONObject versionData = versionsFetch.getJSONObject(i);
            ModrinthRelease release = new ModrinthRelease(versionData.getString("version_number"));
            release.setReleaseType(versionData.getString("version_type"));
            release.setReleaseDate(versionData.getString("date_published"));
            release.setVersionPage(this.getProjectPage() + "/version/" + versionData.getString("version_number"));
            JSONArray downloads = versionData.getJSONArray("files");
            for (int j = 0; j < downloads.length(); ++j) {
                JSONObject downloadData = downloads.getJSONObject(j);
                ModrinthDownload download = new ModrinthDownload();
                download.setDownloadUrl(downloadData.getString("url"));
                download.setFileName(downloadData.getString("filename"));
                JSONObject hashes = downloadData.getJSONObject("hashes");
                download.setSha1Hash(hashes.getString("sha1"));
                download.setSha512Hash(hashes.getString("sha512"));
                release.addDownload(download);
            }
            JSONArray gameVersions = versionData.getJSONArray("game_versions");
            JSONArray supportedLoaders = versionData.getJSONArray("loaders");
            for (int j = 0; j < gameVersions.length(); ++j) {
                release.addSupportedVersion(gameVersions.getString(j));
            }
            for (int k = 0; k < supportedLoaders.length(); ++k) {
                release.addSupportedLoader(supportedLoaders.getString(k));
            }
            this.releases.add(release);
            if (i != 0) continue;
            this.latest = versionData.getString("version_number");
        }
    }

    public List<ModrinthRelease> getReleases() {
        return this.releases;
    }

    @Nullable
    public ModrinthRelease getReleaseByVersion(String version) {
        return this.releases.stream().filter(release -> release.getVersion().equalsIgnoreCase(version)).findFirst().orElse(null);
    }

    @Nullable
    public ModrinthRelease getLatestRelease() {
        return this.releases.stream().filter(release -> release.getVersion().equalsIgnoreCase(this.latest)).findFirst().get();
    }

    public int buildsVersionsBehind(ModrinthRelease release) {
        return this.releases.indexOf(release);
    }

    public String getProjectPage() {
        return "https://modrinth.com/" + this.type + "/" + this.slug;
    }
}

