/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.hyperlib.releases.hangar;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lol.hyper.toolstats.hyperlib.releases.hangar.HangarDownload;

public class HangarRelease {
    private final List<String> supportedVersions = new ArrayList<String>();
    private final String version;
    private final String loader;
    private String author;
    private String versionPage;
    private Date releaseDate;
    private final List<HangarDownload> downloads = new ArrayList<HangarDownload>();

    public HangarRelease(String version, String loader) {
        this.version = version;
        this.loader = loader;
    }

    public void addSupportedVersion(String version) {
        this.supportedVersions.add(version);
    }

    public List<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    public String getLoader() {
        return this.loader;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setReleaseDate(String releaseDate) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(releaseDate, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.releaseDate = Date.from(offsetDateTime.toInstant());
    }

    public List<HangarDownload> getDownloads() {
        return this.downloads;
    }

    public void addDownload(HangarDownload download) {
        this.downloads.add(download);
    }

    public void setVersionPage(String versionPage) {
        this.versionPage = versionPage;
    }

    public String getVersionPage() {
        return this.versionPage;
    }
}

