/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.ArrayList;
import java.util.Date;
import lol.hyper.toolstats.ToolStats;
import lol.hyper.toolstats.hyperlib.datatypes.UUIDDataType;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class VillagerTrade
implements Listener {
    private final ToolStats toolStats;

    public VillagerTrade(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTrade(InventoryClickEvent event) {
        if (event.isCancelled() || event.getCurrentItem() == null) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!(inventory instanceof MerchantInventory)) {
            return;
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        ItemStack tradedItem = event.getCurrentItem();
        Material tradedMaterial = tradedItem.getType();
        if (!this.toolStats.itemChecker.isValidItem(tradedMaterial)) {
            return;
        }
        if (event.isShiftClick()) {
            ItemStack[] beforeTrade = player.getInventory().getContents();
            player.getScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> {
                ItemStack[] afterTrade = player.getInventory().getContents();
                for (int i = 0; i < afterTrade.length; ++i) {
                    ItemStack newItem;
                    ItemStack newSlotItem = afterTrade[i];
                    ItemStack oldSlotItem = beforeTrade[i];
                    if (newSlotItem == null || newSlotItem.getType() != tradedMaterial || oldSlotItem != null || (newItem = this.addTradeOrigin(newSlotItem, player)) == null) continue;
                    player.getInventory().setItem(i, newItem);
                }
            }, null, 1L);
            return;
        }
        ItemStack newItem = this.addTradeOrigin(tradedItem, player);
        if (newItem != null) {
            inventory.setItem(event.getSlot(), newItem);
        }
    }

    private ItemStack addTradeOrigin(ItemStack oldItem, Player owner) {
        Component itemOwner;
        PersistentDataContainer container;
        ItemStack newItem = oldItem.clone();
        ItemMeta meta = newItem.getItemMeta();
        if (meta == null) {
            this.toolStats.logger.warn("{} does NOT have any meta! Unable to update stats.", (Object)newItem);
            return null;
        }
        long timeCreated = System.currentTimeMillis();
        if (this.toolStats.config.getBoolean("normalize-time-creation")) {
            Date finalDate = this.toolStats.numberFormat.normalizeTime(timeCreated);
            timeCreated = finalDate.getTime();
        }
        if ((container = meta.getPersistentDataContainer()).has(this.toolStats.timeCreated, PersistentDataType.LONG) || container.has(this.toolStats.itemOwner, PersistentDataType.LONG)) {
            return null;
        }
        ArrayList<Component> lore = meta.hasLore() ? meta.lore() : new ArrayList<Component>();
        Component creationDate = this.toolStats.itemLore.formatCreationTime(timeCreated, 3, newItem);
        if (creationDate != null) {
            container.set(this.toolStats.timeCreated, PersistentDataType.LONG, (Object)timeCreated);
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)3);
            lore.add(creationDate);
            meta.lore(lore);
        }
        if ((itemOwner = this.toolStats.itemLore.formatOwner(owner.getName(), 3, newItem)) != null) {
            container.set(this.toolStats.itemOwner, (PersistentDataType)new UUIDDataType(), (Object)owner.getUniqueId());
            container.set(this.toolStats.originType, PersistentDataType.INTEGER, (Object)3);
            lore.add(itemOwner);
            meta.lore(lore);
        }
        if (this.toolStats.config.getBoolean("generate-hash-for-items")) {
            String hash = this.toolStats.hashMaker.makeHash(newItem.getType(), owner.getUniqueId(), timeCreated);
            container.set(this.toolStats.hash, PersistentDataType.STRING, (Object)hash);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }
}

