/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import lol.hyper.toolstats.ToolStats;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class ShootBow
implements Listener {
    private final ToolStats toolStats;

    public ShootBow(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onShoot(EntityShootBowEvent event) {
        LivingEntity shooter = event.getEntity();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        ItemStack heldBow = this.toolStats.itemChecker.getBow(player.getInventory());
        if (heldBow == null) {
            return;
        }
        ItemMeta newBow = this.toolStats.itemLore.updateArrowsShot(heldBow, 1);
        if (newBow != null) {
            boolean isOffHand;
            PlayerInventory inventory = player.getInventory();
            boolean isMain = inventory.getItemInMainHand().getType() == Material.BOW || inventory.getItemInMainHand().getType() == Material.CROSSBOW;
            boolean bl = isOffHand = inventory.getItemInOffHand().getType() == Material.BOW || inventory.getItemInOffHand().getType() == Material.CROSSBOW;
            if (isMain && isOffHand) {
                inventory.getItemInMainHand().setItemMeta(newBow);
            } else if (isMain) {
                inventory.getItemInMainHand().setItemMeta(newBow);
            } else if (isOffHand) {
                inventory.getItemInOffHand().setItemMeta(newBow);
            }
        }
    }
}

