/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class EntityDamage
implements Listener {
    private final ToolStats toolStats;
    public final Set<UUID> trackedMobs = new HashSet<UUID>();
    private final List<EntityDamageEvent.DamageCause> ignoredCauses = Arrays.asList(EntityDamageEvent.DamageCause.SUICIDE, EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.CUSTOM, EntityDamageEvent.DamageCause.KILL);

    public EntityDamage(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageByEntityEvent event) {
        Arrow arrow;
        Trident trident;
        ProjectileSource source;
        boolean modDied;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mobBeingAttacked = (LivingEntity)entity;
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (this.ignoredCauses.contains(cause)) {
            return;
        }
        Entity damager = event.getDamager();
        boolean playerAttacking = damager instanceof Player;
        boolean playerBeingAttacked = mobBeingAttacked instanceof Player;
        double finalDamage = event.getFinalDamage();
        boolean bl = modDied = mobBeingAttacked.getHealth() - finalDamage <= 0.0;
        if (playerAttacking) {
            PlayerInventory playerAttackingInventory = ((Player)damager).getInventory();
            if (!this.toolStats.itemChecker.isMeleeWeapon(playerAttackingInventory.getItemInMainHand().getType())) {
                return;
            }
            this.updateWeaponDamage(playerAttackingInventory, event.getFinalDamage());
            if (modDied) {
                if (playerBeingAttacked) {
                    this.updateWeaponKills(playerAttackingInventory, "player");
                } else {
                    this.updateWeaponKills(playerAttackingInventory, "mob");
                }
            }
            this.trackedMobs.add(mobBeingAttacked.getUniqueId());
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> this.trackedMobs.remove(mobBeingAttacked.getUniqueId()), 20L);
        }
        if (damager instanceof Trident && (source = (trident = (Trident)damager).getShooter()) instanceof Player) {
            this.updateTridentDamage(trident, finalDamage);
            if (modDied) {
                if (playerBeingAttacked) {
                    this.updateTridentKills(trident, "player");
                } else {
                    this.updateTridentKills(trident, "mob");
                }
            }
            this.trackedMobs.add(mobBeingAttacked.getUniqueId());
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> this.trackedMobs.remove(mobBeingAttacked.getUniqueId()), 20L);
        }
        if (damager instanceof Arrow && (source = (arrow = (Arrow)damager).getShooter()) instanceof Player) {
            Player shootingPlayer = (Player)source;
            this.updateBowDamage(shootingPlayer.getInventory(), finalDamage);
            if (modDied) {
                if (playerBeingAttacked) {
                    this.updateBowKills(shootingPlayer.getInventory(), "player");
                } else {
                    this.updateBowKills(shootingPlayer.getInventory(), "mob");
                }
            }
            this.trackedMobs.add(mobBeingAttacked.getUniqueId());
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> this.trackedMobs.remove(mobBeingAttacked.getUniqueId()), 20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mobBeingAttacked = (LivingEntity)entity;
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (this.ignoredCauses.contains(cause)) {
            return;
        }
        if (mobBeingAttacked instanceof Player) {
            Player playerTakingDamage = (Player)mobBeingAttacked;
            if (playerTakingDamage.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
                return;
            }
            this.updateArmorDamage(playerTakingDamage.getInventory(), event.getFinalDamage());
        }
    }

    private void updateArmorDamage(PlayerInventory playerInventory, double damage) {
        ItemStack[] armorContents;
        for (ItemStack armorPiece : armorContents = playerInventory.getArmorContents()) {
            ItemMeta newItem;
            if (armorPiece == null || !this.toolStats.itemChecker.isArmor(armorPiece.getType()) || (newItem = this.toolStats.itemLore.updateArmorDamage(armorPiece, damage, false)) == null) continue;
            armorPiece.setItemMeta(newItem);
        }
        playerInventory.setArmorContents(armorContents);
    }

    private void updateBowDamage(PlayerInventory playerInventory, double damage) {
        ItemStack heldBow = this.toolStats.itemChecker.getBow(playerInventory);
        if (heldBow == null) {
            return;
        }
        boolean isMain = playerInventory.getItemInMainHand().getType() == Material.BOW || playerInventory.getItemInMainHand().getType() == Material.CROSSBOW;
        boolean isOffHand = playerInventory.getItemInOffHand().getType() == Material.BOW || playerInventory.getItemInOffHand().getType() == Material.CROSSBOW;
        ItemMeta newBowDamage = this.toolStats.itemLore.updateWeaponDamage(heldBow, damage, false);
        if (newBowDamage != null) {
            if (isMain && isOffHand) {
                playerInventory.getItemInMainHand().setItemMeta(newBowDamage);
            } else if (isMain) {
                playerInventory.getItemInMainHand().setItemMeta(newBowDamage);
            } else if (isOffHand) {
                playerInventory.getItemInOffHand().setItemMeta(newBowDamage);
            }
        }
    }

    private void updateBowKills(PlayerInventory playerInventory, String type) {
        ItemMeta newBowKills;
        ItemMeta newBow;
        boolean isOffHand;
        ItemStack heldBow = this.toolStats.itemChecker.getBow(playerInventory);
        if (heldBow == null) {
            return;
        }
        boolean isMain = playerInventory.getItemInMainHand().getType() == Material.BOW || playerInventory.getItemInMainHand().getType() == Material.CROSSBOW;
        boolean bl = isOffHand = playerInventory.getItemInOffHand().getType() == Material.BOW || playerInventory.getItemInOffHand().getType() == Material.CROSSBOW;
        if (type.equalsIgnoreCase("mob") && (newBow = this.toolStats.itemLore.updateMobKills(heldBow, 1)) != null) {
            if (isMain && isOffHand) {
                playerInventory.getItemInMainHand().setItemMeta(newBow);
            } else if (isMain) {
                playerInventory.getItemInMainHand().setItemMeta(newBow);
            } else if (isOffHand) {
                playerInventory.getItemInOffHand().setItemMeta(newBow);
            }
        }
        if (type.equalsIgnoreCase("player") && (newBowKills = this.toolStats.itemLore.updatePlayerKills(heldBow, 1)) != null) {
            if (isMain && isOffHand) {
                playerInventory.getItemInMainHand().setItemMeta(newBowKills);
            } else if (isMain) {
                playerInventory.getItemInMainHand().setItemMeta(newBowKills);
            } else if (isOffHand) {
                playerInventory.getItemInOffHand().setItemMeta(newBowKills);
            }
        }
    }

    private void updateTridentKills(Trident trident, String type) {
        ItemStack newTrident = trident.getItemStack();
        ItemMeta newKills = type.equalsIgnoreCase("player") ? this.toolStats.itemLore.updatePlayerKills(trident.getItemStack(), 1) : this.toolStats.itemLore.updateMobKills(trident.getItemStack(), 1);
        if (newKills != null) {
            newTrident.setItemMeta(newKills);
            trident.setItemStack(newTrident);
        }
    }

    private void updateTridentDamage(Trident trident, double damage) {
        ItemStack newTrident = trident.getItemStack();
        ItemMeta newDamage = this.toolStats.itemLore.updateWeaponDamage(trident.getItemStack(), damage, false);
        if (newDamage != null) {
            newTrident.setItemMeta(newDamage);
            trident.setItemStack(newTrident);
        }
    }

    private void updateWeaponDamage(PlayerInventory playerInventory, double damage) {
        ItemStack heldWeapon = playerInventory.getItemInMainHand();
        ItemMeta newHeldWeaponMeta = this.toolStats.itemLore.updateWeaponDamage(heldWeapon, damage, false);
        if (newHeldWeaponMeta != null) {
            playerInventory.getItemInMainHand().setItemMeta(newHeldWeaponMeta);
        }
    }

    private void updateWeaponKills(PlayerInventory playerInventory, String type) {
        ItemStack heldWeapon = playerInventory.getItemInMainHand();
        ItemMeta newHeldWeaponMeta = null;
        if (type.equalsIgnoreCase("player")) {
            newHeldWeaponMeta = this.toolStats.itemLore.updatePlayerKills(heldWeapon, 1);
        }
        if (type.equalsIgnoreCase("mob")) {
            newHeldWeaponMeta = this.toolStats.itemLore.updateMobKills(heldWeapon, 1);
        }
        if (newHeldWeaponMeta != null) {
            playerInventory.getItemInMainHand().setItemMeta(newHeldWeaponMeta);
        }
    }
}

