/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ServerPlayerManager
implements Listener {
    public static final ServerPlayerManager INSTANCE = new ServerPlayerManager();
    private final Set<Player> players = new HashSet<Player>();

    public static void init(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)INSTANCE, plugin);
        Voicechat.compatibility.scheduleSyncRepeatingTask(INSTANCE::refresh, 0L, 600L);
    }

    private ServerPlayerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Set<Player> set = this.players;
        synchronized (set) {
            this.players.clear();
            this.players.addAll(Bukkit.getOnlinePlayers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Set<Player> set = this.players;
        synchronized (set) {
            this.players.add(event.getPlayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Set<Player> set = this.players;
        synchronized (set) {
            this.players.remove(event.getPlayer());
        }
    }

    public static ArrayList<Player> getPlayersInRange(World level, Location pos, double range, @Nullable Predicate<Player> filter) {
        return INSTANCE.getPlayersInRangeInternal(level, pos, range, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Player> getPlayersInRangeInternal(World world, Location pos, double range, @Nullable Predicate<Player> filter) {
        ArrayList<Player> nearbyPlayers = new ArrayList<Player>();
        Set<Player> set = this.players;
        synchronized (set) {
            for (Player player : this.players) {
                if (!world.equals((Object)player.getWorld()) || !ServerPlayerManager.isInRange(player.getLocation(), pos, range) || filter != null && !filter.test(player)) continue;
                nearbyPlayers.add(player);
            }
        }
        return nearbyPlayers;
    }

    public static boolean isInRange(Location pos1, Location pos2, double range) {
        return ServerPlayerManager.square(pos1.getX() - pos2.getX()) + ServerPlayerManager.square(pos1.getY() - pos2.getY()) + ServerPlayerManager.square(pos1.getZ() - pos2.getZ()) <= ServerPlayerManager.square(range);
    }

    private static double square(double value) {
        return value * value;
    }
}

