/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.AddCategoryPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RemoveCategoryPacket;
import de.maxhenkel.voicechat.plugins.CategoryManager;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class ServerCategoryManager
extends CategoryManager {
    public void onPlayerCompatibilityCheckSucceeded(Player player) {
        Voicechat.LOGGER.debug("Synchronizing {} volume categories with {}", this.categories.size(), player.getName());
        for (VolumeCategoryImpl category : this.getCategories()) {
            this.broadcastAddCategory(category);
        }
    }

    @Override
    public void addCategory(VolumeCategoryImpl category) {
        super.addCategory(category);
        Voicechat.LOGGER.debug("Synchronizing volume category {} with all players", category.getId());
        this.broadcastAddCategory(category);
    }

    @Override
    @Nullable
    public VolumeCategoryImpl removeCategory(String categoryId) {
        VolumeCategoryImpl volumeCategory = super.removeCategory(categoryId);
        Voicechat.LOGGER.debug("Removing volume category {} for all players", categoryId);
        this.broadcastRemoveCategory(categoryId);
        return volumeCategory;
    }

    private void broadcastAddCategory(VolumeCategoryImpl category) {
        AddCategoryPacket packet = new AddCategoryPacket(category);
        Voicechat.INSTANCE.getServer().getOnlinePlayers().forEach(p -> NetManager.sendToClient(p, packet));
    }

    private void broadcastRemoveCategory(String categoryId) {
        RemoveCategoryPacket packet = new RemoveCategoryPacket(categoryId);
        Voicechat.INSTANCE.getServer().getOnlinePlayers().forEach(p -> NetManager.sendToClient(p, packet));
    }
}

