/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import de.maxhenkel.voicechat.concentus.OpusApplication;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusEncoderImpl;

public class OpusManager {
    public static final int SAMPLE_RATE = 48000;
    public static final int FRAME_SIZE = 960;

    public static OpusEncoder createEncoder(int sampleRate, int frameSize, int maxPayloadSize, OpusApplication application) {
        return new JavaOpusEncoderImpl(sampleRate, frameSize, maxPayloadSize, application);
    }

    public static OpusEncoder createEncoder(OpusEncoderMode mode) {
        OpusApplication application = OpusApplication.OPUS_APPLICATION_VOIP;
        if (mode != null) {
            switch (mode) {
                case AUDIO: {
                    application = OpusApplication.OPUS_APPLICATION_AUDIO;
                    break;
                }
                case RESTRICTED_LOWDELAY: {
                    application = OpusApplication.OPUS_APPLICATION_RESTRICTED_LOWDELAY;
                    break;
                }
            }
        }
        return OpusManager.createEncoder(48000, 960, 1024, application);
    }

    public static OpusDecoder createDecoder(int sampleRate, int frameSize) {
        return new JavaOpusDecoderImpl(sampleRate, frameSize);
    }

    public static OpusDecoder createDecoder() {
        return OpusManager.createDecoder(48000, 960);
    }
}

