/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.Key;
import java.util.UUID;
import javax.annotation.Nullable;

public class JoinedGroupPacket
implements Packet<JoinedGroupPacket> {
    public static final Key JOINED_GROUP = Voicechat.compatibility.createNamespacedKey("joined_group");
    @Nullable
    private UUID group;
    private boolean wrongPassword;

    public JoinedGroupPacket() {
    }

    public JoinedGroupPacket(@Nullable UUID group, boolean wrongPassword) {
        this.group = group;
        this.wrongPassword = wrongPassword;
    }

    @Nullable
    public UUID getGroup() {
        return this.group;
    }

    public boolean isWrongPassword() {
        return this.wrongPassword;
    }

    @Override
    public Key getID() {
        return JOINED_GROUP;
    }

    @Override
    public JoinedGroupPacket fromBytes(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.group = buf.readUUID();
        }
        this.wrongPassword = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.group != null);
        if (this.group != null) {
            buf.writeUUID(this.group);
        }
        buf.writeBoolean(this.wrongPassword);
    }
}

