/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.compatibility;

import com.mojang.brigadier.arguments.ArgumentType;
import de.maxhenkel.voicechat.compatibility.FallbackCompatibility;
import de.maxhenkel.voicechat.compatibility.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SpigotCompatibility
extends FallbackCompatibility {
    public static final SpigotCompatibility INSTANCE = new SpigotCompatibility();
    private MessageSender messageSender;

    @Override
    public void init() throws Exception {
        super.init();
        Class<?> playerSpigotClass = ReflectionUtils.getClazz("org.bukkit.entity.Player$Spigot");
        Class<?> baseComponentClass = ReflectionUtils.getClazz("net.md_5.bungee.api.chat.BaseComponent");
        Class<?> chatMessageTypeClass = ReflectionUtils.getClazz("net.md_5.bungee.api.ChatMessageType");
        Object systemType = ReflectionUtils.getField(chatMessageTypeClass, "SYSTEM");
        Object actionBarType = ReflectionUtils.getField(chatMessageTypeClass, "ACTION_BAR");
        Method playerSpigot = ReflectionUtils.getMethod(Player.class, "spigot");
        Method sendMessage = ReflectionUtils.getMethod(playerSpigotClass, new String[]{"sendMessage"}, new Class[]{chatMessageTypeClass, baseComponentClass});
        Class<?> translatableComponentClass = ReflectionUtils.getClazz("net.md_5.bungee.api.chat.TranslatableComponent");
        Constructor<?> translatableComponentConstructor = ReflectionUtils.getConstructor(translatableComponentClass, String.class, Object[].class);
        this.messageSender = (player, actionBar, key, args) -> {
            Object messageType = actionBar ? actionBarType : systemType;
            ReflectionUtils.call(sendMessage, ReflectionUtils.call(playerSpigot, player, new Object[0]), messageType, ReflectionUtils.newInstance(translatableComponentConstructor, key, args));
        };
    }

    public static boolean isSpigotCompatible() {
        return ReflectionUtils.doesMethodExist(Bukkit.class, "spigot", new Class[0]);
    }

    @Override
    public void sendTranslationMessage(Player player, String key, String ... args) {
        this.messageSender.send(player, false, key, args);
    }

    @Override
    public void sendStatusMessage(Player player, String key, String ... args) {
        this.messageSender.send(player, true, key, args);
    }

    @Override
    @Nullable
    public ArgumentType<?> playerArgument() {
        return null;
    }

    @Override
    @Nullable
    public ArgumentType<?> uuidArgument() {
        return null;
    }

    private static interface MessageSender {
        public void send(Player var1, boolean var2, String var3, String ... var4);
    }
}

