/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VoiceChatCommands
implements CommandExecutor,
TabCompleter {
    public static final String VOICECHAT_COMMAND = "voicechat";

    public boolean onCommand(CommandSender commandSender, Command command, String label, String[] args) {
        if (VoiceChatCommands.checkNoVoicechat(commandSender)) {
            return true;
        }
        if (!(commandSender instanceof Player)) {
            return true;
        }
        Player sender = (Player)commandSender;
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("help")) {
                return this.helpCommand(sender, command, label, args);
            }
            if (args[0].equalsIgnoreCase("test")) {
                if (commandSender.hasPermission(PermissionManager.ADMIN_PERMISSION)) {
                    return this.testCommand(sender, command, label, args);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("invite")) {
                return this.inviteCommand(sender, command, label, args);
            }
            if (args[0].equalsIgnoreCase("join")) {
                return this.joinCommand(sender, command, label, args);
            }
            if (args[0].equalsIgnoreCase("leave")) {
                return this.leaveCommand(sender, command, label, args);
            }
        }
        return this.helpCommand(sender, command, label, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String arg;
        if (args.length == 1) {
            return this.tabCompleteList(args[0], Arrays.asList("help", "test", "invite", "join", "leave"));
        }
        if (args.length == 2) {
            arg = args[0];
            if (arg.equals("test") || arg.equals("invite")) {
                return null;
            }
            if (arg.startsWith("join")) {
                return Collections.emptyList();
            }
        }
        if (args.length == 3 && (arg = args[0]).startsWith("join")) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<String> tabCompleteList(String arg, List<String> list) {
        return list.stream().filter(s -> s.startsWith(arg)).collect(Collectors.toList());
    }

    private boolean helpCommand(Player commandSender, Command command, String label, String[] args) {
        commandSender.sendMessage("/voicechat [help]");
        commandSender.sendMessage("/voicechat [test] <target>");
        commandSender.sendMessage("/voicechat [invite] <target>");
        commandSender.sendMessage("/voicechat [join] <group> [<password>]");
        commandSender.sendMessage("/voicechat [leave]");
        return true;
    }

    private boolean testCommand(final Player commandSender, Command command, String label, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Player player = VoiceChatCommands.parsePlayer((CommandSender)commandSender, args[1]);
        if (player == null) {
            NetManager.sendMessage(commandSender, "argument.entity.notfound.player", new String[0]);
            return true;
        }
        if (!Voicechat.SERVER.isCompatible(player)) {
            NetManager.sendMessage(commandSender, "message.voicechat.player_no_voicechat", player.getDisplayName(), "Simple Voice Chat");
            return true;
        }
        ClientConnection clientConnection = Voicechat.SERVER.getServer().getConnections().get(player.getUniqueId());
        if (clientConnection == null) {
            NetManager.sendMessage(commandSender, "message.voicechat.client_not_connected", new String[0]);
            return true;
        }
        try {
            NetManager.sendMessage(commandSender, "message.voicechat.sending_ping", new String[0]);
            Voicechat.SERVER.getServer().getPingManager().sendPing(clientConnection, 500L, 10, new PingManager.PingListener(){

                @Override
                public void onPong(int attempts, long pingMilliseconds) {
                    if (attempts <= 1) {
                        NetManager.sendMessage(commandSender, "message.voicechat.ping_received", String.valueOf(pingMilliseconds));
                    } else {
                        NetManager.sendMessage(commandSender, "message.voicechat.ping_received_attempt", String.valueOf(pingMilliseconds), String.valueOf(attempts));
                    }
                }

                @Override
                public void onFailedAttempt(int attempts) {
                    NetManager.sendMessage(commandSender, "message.voicechat.ping_retry", new String[0]);
                }

                @Override
                public void onTimeout(int attempts) {
                    NetManager.sendMessage(commandSender, "message.voicechat.ping_timed_out", String.valueOf(attempts));
                }
            });
            NetManager.sendMessage(commandSender, "message.voicechat.ping_sent_waiting", new String[0]);
        }
        catch (Exception e) {
            NetManager.sendMessage(commandSender, "message.voicechat.failed_to_send_ping", e.getMessage());
            Voicechat.LOGGER.warn("Failed to send ping", e);
        }
        return true;
    }

    private boolean inviteCommand(Player commandSender, Command command, String label, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Player player = VoiceChatCommands.parsePlayer((CommandSender)commandSender, args[1]);
        if (player == null) {
            NetManager.sendMessage(commandSender, "argument.entity.notfound.player", new String[0]);
            return true;
        }
        PlayerState state = Voicechat.SERVER.getServer().getPlayerStateManager().getState(commandSender.getUniqueId());
        if (state == null || !state.hasGroup()) {
            NetManager.sendMessage(commandSender, "message.voicechat.not_in_group", new String[0]);
            return true;
        }
        Group group = Voicechat.SERVER.getServer().getGroupManager().getGroup(state.getGroup());
        if (group == null) {
            return true;
        }
        if (!Voicechat.SERVER.isCompatible(player)) {
            NetManager.sendMessage(commandSender, "message.voicechat.player_no_voicechat", player.getDisplayName(), "Simple Voice Chat");
            return true;
        }
        String passwordSuffix = group.getPassword() == null ? "" : " \"" + group.getPassword() + "\"";
        String cmd = "/voicechat join " + group.getId().toString() + passwordSuffix;
        Voicechat.compatibility.sendInviteMessage(player, commandSender, group.getName(), cmd);
        NetManager.sendMessage(commandSender, "message.voicechat.invite_successful", player.getName());
        return true;
    }

    private boolean joinCommand(Player commandSender, Command command, String label, String[] args) {
        UUID groupUUID;
        int argIndex;
        if (args.length < 2) {
            return false;
        }
        try {
            groupUUID = UUID.fromString(args[argIndex]);
        }
        catch (Exception e) {
            String groupName;
            if (args[argIndex].startsWith("\"")) {
                String[] split;
                StringBuilder sb = new StringBuilder();
                for (argIndex = 1; argIndex < args.length; ++argIndex) {
                    sb.append(args[argIndex]).append(" ");
                    if (args[argIndex].endsWith("\"") && !args[argIndex].endsWith("\\\"")) break;
                }
                if ((split = (groupName = sb.toString().trim()).split("\"")).length > 1) {
                    groupName = split[1];
                }
            } else {
                groupName = args[argIndex];
            }
            groupUUID = this.getGroupUUID(commandSender, Voicechat.SERVER.getServer(), groupName);
        }
        if (groupUUID == null) {
            return true;
        }
        String password = null;
        if (args.length >= ++argIndex + 1) {
            String[] split;
            StringBuilder sb = new StringBuilder();
            while (argIndex < args.length) {
                sb.append(args[argIndex]).append(" ");
                ++argIndex;
            }
            password = sb.toString().trim();
            if (password.startsWith("\"") && (split = password.split("\"")).length > 1) {
                password = split[1];
            }
        }
        VoiceChatCommands.joinGroup(commandSender, groupUUID, password);
        return true;
    }

    private UUID getGroupUUID(Player commandSender, Server server, String groupName) {
        List groups = server.getGroupManager().getGroups().values().stream().filter(group -> group.getName().equals(groupName)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            NetManager.sendMessage(commandSender, "message.voicechat.group_does_not_exist", new String[0]);
            return null;
        }
        if (groups.size() > 1) {
            NetManager.sendMessage(commandSender, "message.voicechat.group_name_not_unique", new String[0]);
            return null;
        }
        return ((Group)groups.get(0)).getId();
    }

    private static void joinGroup(Player commandSender, UUID groupID, @Nullable String password) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            NetManager.sendMessage(commandSender, "message.voicechat.groups_disabled", new String[0]);
            return;
        }
        Server server = Voicechat.SERVER.getServer();
        if (!commandSender.hasPermission(PermissionManager.GROUPS_PERMISSION)) {
            NetManager.sendMessage(commandSender, "message.voicechat.no_group_permission", new String[0]);
            return;
        }
        Group group = server.getGroupManager().getGroup(groupID);
        if (group == null) {
            NetManager.sendMessage(commandSender, "message.voicechat.group_does_not_exist", new String[0]);
            return;
        }
        server.getGroupManager().joinGroup(group, commandSender, password);
        NetManager.sendMessage(commandSender, "message.voicechat.join_successful", group.getName());
    }

    private boolean leaveCommand(Player commandSender, Command command, String label, String[] args) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            NetManager.sendMessage(commandSender, "message.voicechat.groups_disabled", new String[0]);
            return true;
        }
        Server server = Voicechat.SERVER.getServer();
        PlayerState state = server.getPlayerStateManager().getState(commandSender.getUniqueId());
        if (state == null || !state.hasGroup()) {
            NetManager.sendMessage(commandSender, "message.voicechat.not_in_group", new String[0]);
            return true;
        }
        server.getGroupManager().leaveGroup(commandSender);
        NetManager.sendMessage(commandSender, "message.voicechat.leave_successful", new String[0]);
        return true;
    }

    private static boolean checkNoVoicechat(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            if (Voicechat.SERVER.isCompatible((Player)commandSender)) {
                return false;
            }
            commandSender.sendMessage(String.format(Voicechat.TRANSLATIONS.voicechatNeededForCommandMessage.get(), "Simple Voice Chat"));
        } else {
            commandSender.sendMessage(Voicechat.TRANSLATIONS.playerCommandMessage.get());
        }
        return true;
    }

    @Nullable
    public static Player parsePlayer(CommandSender commandSender, String playerArg) {
        Player player = commandSender.getServer().getPlayer(playerArg);
        if (player != null) {
            return player;
        }
        try {
            UUID uuid = UUID.fromString(playerArg);
            return commandSender.getServer().getPlayer(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

