/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.compatibility.PlayerHideEvent;
import de.maxhenkel.voicechat.compatibility.PlayerShowEvent;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RemovePlayerStatePacket;
import de.maxhenkel.voicechat.net.UpdateStatePacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerStateManager
implements Listener {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();

    public void onUpdateStatePacket(Player player, UpdateStatePacket packet) {
        PlayerState state = this.states.get(player.getUniqueId());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisabled(packet.isDisabled());
        this.states.put(player.getUniqueId(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Got state of {}: {}", player.getName(), state);
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        this.states.remove(event.getPlayer().getUniqueId());
        this.broadcastRemoveState(event.getPlayer());
        Voicechat.LOGGER.debug("Removing state of {}", event.getPlayer().getName());
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(event.getPlayer());
        this.states.put(event.getPlayer().getUniqueId(), state);
        this.broadcastState(event.getPlayer(), state);
        Voicechat.LOGGER.debug("Setting default state of {}: {}", event.getPlayer().getName(), state);
    }

    public void onPlayerHide(PlayerHideEvent event) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(event.getHiddenPlayer().getUniqueId());
        NetManager.sendToClient(event.getObserver(), packet);
        Voicechat.LOGGER.debug("Removing state of {} for {}", event.getHiddenPlayer().getName(), event.getObserver().getName());
    }

    public void onPlayerShow(PlayerShowEvent event) {
        PlayerState state = this.states.get(event.getShownPlayer().getUniqueId());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(event.getShownPlayer());
        }
        PlayerStatePacket packet = new PlayerStatePacket(state);
        NetManager.sendToClient(event.getObserver(), packet);
        Voicechat.LOGGER.debug("Sending state of {} to {}", event.getShownPlayer().getName(), event.getObserver().getName());
    }

    public void broadcastState(@Nullable Player stateOwner, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        for (Player receiver : Voicechat.INSTANCE.getServer().getOnlinePlayers()) {
            if (stateOwner != null && !Voicechat.compatibility.canSee(receiver, stateOwner)) continue;
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(state);
    }

    public void broadcastRemoveState(Player stateOwner) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(stateOwner.getUniqueId());
        for (Player receiver : Voicechat.INSTANCE.getServer().getOnlinePlayers()) {
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(PlayerStateManager.defaultDisconnectedState(stateOwner));
    }

    public void onPlayerCompatibilityCheckSucceeded(Player player) {
        ArrayList<PlayerState> stateList = new ArrayList<PlayerState>(this.states.size());
        for (PlayerState state : this.states.values()) {
            Player otherPlayer = Voicechat.INSTANCE.getServer().getPlayer(state.getUuid());
            if (otherPlayer == null || !Voicechat.compatibility.canSee(player, otherPlayer)) continue;
            stateList.add(state);
        }
        PlayerStatesPacket packet = new PlayerStatesPacket(stateList);
        NetManager.sendToClient(player, packet);
        Voicechat.LOGGER.debug("Sending initial states to {}", player.getName());
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        Player player = Bukkit.getPlayer((UUID)uuid);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to disconnected: {}", uuid, state);
    }

    public void onPlayerVoicechatConnect(Player player) {
        PlayerState state = this.states.get(player.getUniqueId());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.getUniqueId(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to connected: {}", player.getName(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(Player player) {
        return new PlayerState(player.getUniqueId(), player.getName(), false, true);
    }

    public void setGroup(Player player, @Nullable UUID group) {
        PlayerState state = this.states.get(player.getUniqueId());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.LOGGER.debug("Defaulting to default state for {}: {}", player.getName(), state);
        }
        state.setGroup(group);
        this.states.put(player.getUniqueId(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting group of {}: {}", player.getName(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

