/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.logging;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.logging.LogLevel;
import de.maxhenkel.voicechat.logging.VoicechatLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLoggingLogger
implements VoicechatLogger {
    private final boolean debugMode;
    private final Logger logger;
    private static final String PLACEHOLDER = "{}";

    public JavaLoggingLogger(Logger logger) {
        this.logger = logger;
        this.debugMode = Voicechat.debugMode();
    }

    @Override
    public void log(LogLevel level, String message, Object ... args) {
        if (!this.isEnabled(level)) {
            return;
        }
        Throwable throwable = null;
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            throwable = (Throwable)args[args.length - 1];
            Object[] newArgs = new Object[args.length - 1];
            System.arraycopy(args, 0, newArgs, 0, newArgs.length);
            args = newArgs;
        }
        this.logger.log(this.fromLogLevel(level), this.replacePlaceholders(message, args), throwable);
    }

    private String replacePlaceholders(String message, Object ... args) {
        StringBuilder formattedMessage = new StringBuilder();
        int placeholderStart = message.indexOf(PLACEHOLDER);
        for (int argIndex = 0; placeholderStart >= 0 && argIndex < args.length; ++argIndex) {
            formattedMessage.append(message, 0, placeholderStart);
            formattedMessage.append(args[argIndex]);
            message = message.substring(placeholderStart + PLACEHOLDER.length());
            placeholderStart = message.indexOf(PLACEHOLDER);
        }
        formattedMessage.append(message);
        return formattedMessage.toString();
    }

    @Override
    public boolean isEnabled(LogLevel level) {
        return this.logger.isLoggable(this.fromLogLevel(level));
    }

    private Level fromLogLevel(LogLevel level) {
        if (this.debugMode) {
            switch (level) {
                case TRACE: {
                    return Level.ALL;
                }
                case WARN: {
                    return Level.WARNING;
                }
                case ERROR: 
                case FATAL: {
                    return Level.SEVERE;
                }
            }
            return Level.INFO;
        }
        switch (level) {
            case TRACE: {
                return Level.ALL;
            }
            case DEBUG: {
                return Level.CONFIG;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: 
            case FATAL: {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

