/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.util;

public class Key {
    private final String namespace;
    private final String value;

    public Key(String namespace, String value) {
        this.namespace = namespace;
        this.value = value;
    }

    public static Key of(String namespace, String value) {
        return new Key(namespace, value);
    }

    public static Key of(String value) {
        return new Key("voicechat", value);
    }

    public static Key parse(String value) {
        String[] split = value.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid key: %s", value));
        }
        return new Key(split[0], split[1]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s:%s", this.namespace, this.value);
    }
}

