/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.compatibility;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.compatibility.Compatibility;
import de.maxhenkel.voicechat.compatibility.CompatibilityReflectionException;
import de.maxhenkel.voicechat.compatibility.PlayerHideEvent;
import de.maxhenkel.voicechat.compatibility.PlayerShowEvent;
import de.maxhenkel.voicechat.compatibility.ReflectionUtils;
import de.maxhenkel.voicechat.util.Key;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;

public abstract class BaseCompatibility
implements Compatibility {
    private String baseBukkitPackage;
    private String baseServerPackage;
    private Method addChannel;
    private Method removeChannel;
    @Nullable
    private Class<? extends PlayerEvent> playerHideEntityEvent;
    @Nullable
    private Method playerHideEntityEventGetEntity;
    @Nullable
    private Class<? extends PlayerEvent> playerShowEntityEvent;
    @Nullable
    private Method playerShowEntityEventGetEntity;
    private Consumer<Runnable> runTask;
    private TaskScheduler taskScheduler;

    @Override
    public void init() throws Exception {
        Compatibility.super.init();
        this.baseBukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
        this.baseServerPackage = ReflectionUtils.callMethod((Object)Bukkit.getServer(), "getServer").getClass().getPackage().getName();
        Class<?> craftPlayer = this.getBukkitClass("entity.CraftPlayer");
        this.addChannel = ReflectionUtils.getMethod(craftPlayer, new String[]{"addChannel"}, new Class[]{String.class});
        this.removeChannel = ReflectionUtils.getMethod(craftPlayer, new String[]{"removeChannel"}, new Class[]{String.class});
        try {
            if (ReflectionUtils.doesClassExist("org.bukkit.event.player.PlayerHideEntityEvent") && ReflectionUtils.doesClassExist("org.bukkit.event.player.PlayerShowEntityEvent")) {
                Class<?> hide = ReflectionUtils.getClazz("org.bukkit.event.player.PlayerHideEntityEvent");
                if (!PlayerEvent.class.isAssignableFrom(hide)) {
                    throw new CompatibilityReflectionException("PlayerHideEntityEvent is not a subclass of PlayerEvent");
                }
                Class<?> show = ReflectionUtils.getClazz("org.bukkit.event.player.PlayerShowEntityEvent");
                if (!PlayerEvent.class.isAssignableFrom(show)) {
                    throw new CompatibilityReflectionException("PlayerShowEntityEvent is not a subclass of PlayerEvent");
                }
                this.playerShowEntityEventGetEntity = ReflectionUtils.getMethod(show, "getEntity");
                this.playerHideEntityEventGetEntity = ReflectionUtils.getMethod(hide, "getEntity");
                this.playerShowEntityEvent = show;
                this.playerHideEntityEvent = hide;
            } else {
                Voicechat.LOGGER.warn("Vanish plugin integration is not supported", new Object[0]);
            }
        }
        catch (CompatibilityReflectionException e) {
            Voicechat.LOGGER.warn("Vanish plugin integration is disabled", new Object[0]);
            Voicechat.LOGGER.warn("Failed to load vanish compatibility", e);
            this.playerHideEntityEvent = null;
            this.playerShowEntityEvent = null;
        }
        this.runTask = runnable -> Bukkit.getScheduler().runTask((Plugin)Voicechat.INSTANCE, runnable);
        this.taskScheduler = new TaskScheduler(){

            @Override
            public void scheduleSyncRepeatingTask(Runnable runnable, long delay, long period) {
                Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Voicechat.INSTANCE, runnable, delay, period);
            }

            @Override
            public void runTaskLater(Runnable runnable, long delay) {
                Bukkit.getScheduler().runTaskLater((Plugin)Voicechat.INSTANCE, runnable, delay);
            }
        };
        if (ReflectionUtils.doesMethodExist(Bukkit.class, "getGlobalRegionScheduler", new Class[0])) {
            final Object globalRegionScheduler = ReflectionUtils.callMethod(Bukkit.class, "getGlobalRegionScheduler");
            Method run = ReflectionUtils.getMethod(globalRegionScheduler.getClass(), new String[]{"run"}, new Class[]{Plugin.class, Consumer.class});
            this.runTask = runnable -> ReflectionUtils.call(run, globalRegionScheduler, new Object[]{Voicechat.INSTANCE, task -> runnable.run()});
            if (ReflectionUtils.doesMethodExist(globalRegionScheduler.getClass(), "runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE) && ReflectionUtils.doesMethodExist(globalRegionScheduler.getClass(), "runDelayed", Plugin.class, Consumer.class, Long.TYPE)) {
                final Method runAtFixedRate = ReflectionUtils.getMethod(globalRegionScheduler.getClass(), new String[]{"runAtFixedRate"}, new Class[]{Plugin.class, Consumer.class, Long.TYPE, Long.TYPE});
                final Method runDelayed = ReflectionUtils.getMethod(globalRegionScheduler.getClass(), new String[]{"runDelayed"}, new Class[]{Plugin.class, Consumer.class, Long.TYPE});
                this.taskScheduler = new TaskScheduler(){

                    @Override
                    public void scheduleSyncRepeatingTask(Runnable runnable, long delay, long period) {
                        ReflectionUtils.call(runAtFixedRate, globalRegionScheduler, new Object[]{Voicechat.INSTANCE, task -> runnable.run(), delay <= 0L ? 1L : delay, period});
                    }

                    @Override
                    public void runTaskLater(Runnable runnable, long delay) {
                        ReflectionUtils.call(runDelayed, globalRegionScheduler, new Object[]{Voicechat.INSTANCE, task -> runnable.run(), delay <= 0L ? 1L : delay});
                    }
                };
            }
        }
    }

    @Override
    public void addChannel(Player player, String channel) {
        ReflectionUtils.call(this.addChannel, player, channel);
    }

    @Override
    public void removeChannel(Player player, String channel) {
        ReflectionUtils.call(this.removeChannel, player, channel);
    }

    @Override
    public Key createNamespacedKey(String key) {
        return Key.of(key);
    }

    @Override
    public void runTask(Runnable runnable) {
        this.runTask.accept(runnable);
    }

    @Override
    public void scheduleSyncRepeatingTask(Runnable runnable, long delay, long period) {
        this.taskScheduler.scheduleSyncRepeatingTask(runnable, delay, period);
    }

    @Override
    public void runTaskLater(Runnable runnable, long delay) {
        this.taskScheduler.runTaskLater(runnable, delay);
    }

    @Override
    public boolean canSee(Player player, Player other) {
        if (this.playerHideEntityEvent == null || this.playerShowEntityEvent == null) {
            return true;
        }
        return player.canSee(other);
    }

    @Override
    public void registerPlayerHideEvent(Consumer<PlayerHideEvent> event) {
        if (this.playerHideEntityEvent == null) {
            return;
        }
        Bukkit.getPluginManager().registerEvent(this.playerHideEntityEvent, new Listener(){}, EventPriority.NORMAL, (listener, evt) -> {
            if (!evt.getClass().isAssignableFrom(this.playerHideEntityEvent)) {
                return;
            }
            PlayerEvent playerEvent = (PlayerEvent)evt;
            Object entityObj = ReflectionUtils.call(this.playerHideEntityEventGetEntity, playerEvent, new Object[0]);
            if (!(entityObj instanceof Player)) {
                return;
            }
            event.accept(new PlayerHideEvent((Player)entityObj, playerEvent.getPlayer()));
        }, (Plugin)Voicechat.INSTANCE);
    }

    @Override
    public void registerPlayerShowEvent(Consumer<PlayerShowEvent> event) {
        if (this.playerShowEntityEvent == null) {
            return;
        }
        Bukkit.getPluginManager().registerEvent(this.playerShowEntityEvent, new Listener(){}, EventPriority.NORMAL, (listener, evt) -> {
            if (!evt.getClass().isAssignableFrom(this.playerShowEntityEvent)) {
                return;
            }
            PlayerEvent playerEvent = (PlayerEvent)evt;
            Object entityObj = ReflectionUtils.call(this.playerShowEntityEventGetEntity, playerEvent, new Object[0]);
            if (!(entityObj instanceof Player)) {
                return;
            }
            event.accept(new PlayerShowEvent((Player)entityObj, playerEvent.getPlayer()));
        }, (Plugin)Voicechat.INSTANCE);
    }

    @Override
    public String getBaseBukkitPackage() {
        return this.baseBukkitPackage;
    }

    @Override
    public String getBaseServerPackage() {
        return this.baseServerPackage;
    }

    private static interface TaskScheduler {
        public void scheduleSyncRepeatingTask(Runnable var1, long var2, long var4);

        public void runTaskLater(Runnable var1, long var2);
    }
}

