/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.BuildConstants;
import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.command.VoiceChatCommands;
import de.maxhenkel.voicechat.commodore.Commodore;
import de.maxhenkel.voicechat.commodore.CommodoreProvider;
import de.maxhenkel.voicechat.compatibility.BukkitCompatibilityManager;
import de.maxhenkel.voicechat.compatibility.Compatibility;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.config.Translations;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.integration.commodore.CommodoreCommands;
import de.maxhenkel.voicechat.integration.commodore.MissingArgumentTypeException;
import de.maxhenkel.voicechat.integration.placeholderapi.VoicechatExpansion;
import de.maxhenkel.voicechat.integration.viaversion.ViaVersionCompatibility;
import de.maxhenkel.voicechat.logging.JavaLoggingLogger;
import de.maxhenkel.voicechat.logging.VoicechatLogger;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.BukkitVoicechatServiceImpl;
import de.maxhenkel.voicechat.voice.server.ServerPlayerManager;
import de.maxhenkel.voicechat.voice.server.ServerVoiceEvents;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class Voicechat
extends JavaPlugin {
    public static Voicechat INSTANCE;
    public static final String MODID = "voicechat";
    public static VoicechatLogger LOGGER;
    public static int COMPATIBILITY_VERSION;
    public static ServerConfig SERVER_CONFIG;
    public static Translations TRANSLATIONS;
    public static ServerVoiceEvents SERVER;
    public static BukkitVoicechatServiceImpl apiService;
    public static NetManager netManager;
    public static Compatibility compatibility;
    public static final int MAX_GROUP_NAME_LENGTH = 24;
    public static final Pattern GROUP_REGEX;

    public void onEnable() {
        block17: {
            INSTANCE = this;
            LOGGER = new JavaLoggingLogger(this.getLogger());
            if (Voicechat.debugMode()) {
                LOGGER.warn("Running in debug mode - Don't leave this enabled in production!", new Object[0]);
            }
            try {
                compatibility = BukkitCompatibilityManager.loadCompatibility();
                if (compatibility == null) {
                    this.disablePlugin();
                    return;
                }
            }
            catch (Throwable t) {
                LOGGER.fatal("An unexpected error occurred while loading compatibility", t);
                this.disablePlugin();
                return;
            }
            LOGGER.info("Compatibility version {}", COMPATIBILITY_VERSION);
            SERVER_CONFIG = ConfigBuilder.builder(ServerConfig::new).path(this.getDataFolder().toPath().resolve("voicechat-server.properties")).build();
            TRANSLATIONS = ConfigBuilder.builder(Translations::new).path(this.getDataFolder().toPath().resolve("translations.properties")).build();
            netManager = new NetManager();
            netManager.onEnable();
            apiService = new BukkitVoicechatServiceImpl();
            this.getServer().getServicesManager().register(BukkitVoicechatService.class, (Object)apiService, (Plugin)this, ServicePriority.Normal);
            PluginCommand voicechatCommand = this.getCommand(MODID);
            if (voicechatCommand != null) {
                VoiceChatCommands voiceChatCommands = new VoiceChatCommands();
                voicechatCommand.setExecutor((CommandExecutor)voiceChatCommands);
                voicechatCommand.setTabCompleter((TabCompleter)voiceChatCommands);
                try {
                    if (CommodoreProvider.isSupported()) {
                        Commodore commodore = CommodoreProvider.getCommodore((Plugin)this);
                        CommodoreCommands.registerCompletions(commodore);
                        LOGGER.info("Successfully initialized commodore command completion", new Object[0]);
                        break block17;
                    }
                    LOGGER.warn("Commodore command completion is not supported", new Object[0]);
                }
                catch (MissingArgumentTypeException t) {
                    LOGGER.warn("Failed to initialize commodore command completion: {}", t.getMessage());
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to initialize commodore command completion", t);
                }
            } else {
                LOGGER.error("Failed to register commands", new Object[0]);
            }
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new VoicechatExpansion().register();
                LOGGER.info("Successfully registered PlaceholderAPI expansion", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to register PlaceholderAPI expansion", t);
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("ViaVersion") != null) {
                ViaVersionCompatibility.register();
                LOGGER.info("Successfully added ViaVersion mappings", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to add ViaVersion mappings", t);
        }
        if (System.getProperty("VOICECHAT_RELOADED") != null) {
            LOGGER.error("{} does not support reloads! Expect that things will break!", "Simple Voice Chat");
        }
        System.setProperty("VOICECHAT_RELOADED", "true");
        compatibility.runTask(() -> {
            SERVER = new ServerVoiceEvents();
            PluginManager.instance().init();
            SERVER.init();
            Bukkit.getPluginManager().registerEvents((Listener)SERVER, (Plugin)this);
            ServerPlayerManager.init((Plugin)this);
        });
    }

    private void disablePlugin() {
        LOGGER.fatal("Disabling {}", "Simple Voice Chat");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void onDisable() {
        if (netManager != null) {
            netManager.onDisable();
        }
        this.getServer().getServicesManager().unregister((Object)apiService);
        if (SERVER != null) {
            SERVER.getServer().close();
        }
    }

    public static boolean debugMode() {
        return System.getProperty("voicechat.debug") != null;
    }

    static {
        COMPATIBILITY_VERSION = BuildConstants.COMPATIBILITY_VERSION;
        GROUP_REGEX = Pattern.compile("^[^\\p{C}\\s][^\\p{C}]{0,23}$");
    }
}

