/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.AddCategoryPacket;
import de.maxhenkel.voicechat.net.AddGroupPacket;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RemoveCategoryPacket;
import de.maxhenkel.voicechat.net.RemoveGroupPacket;
import de.maxhenkel.voicechat.net.RemovePlayerStatePacket;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.net.UpdateStatePacket;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class NetManager
implements Listener {
    private final Set<String> packets = new HashSet<String>();

    public void onEnable() {
        this.packets.clear();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Voicechat.INSTANCE);
        try {
            this.registerIncomingPacket(UpdateStatePacket.class);
            this.registerIncomingPacket(RequestSecretPacket.class);
            this.registerIncomingPacket(CreateGroupPacket.class);
            this.registerIncomingPacket(JoinGroupPacket.class);
            this.registerIncomingPacket(LeaveGroupPacket.class);
            this.registerOutgoingPacket(SecretPacket.class);
            this.registerOutgoingPacket(PlayerStatesPacket.class);
            this.registerOutgoingPacket(PlayerStatePacket.class);
            this.registerOutgoingPacket(RemovePlayerStatePacket.class);
            this.registerOutgoingPacket(AddGroupPacket.class);
            this.registerOutgoingPacket(RemoveGroupPacket.class);
            this.registerOutgoingPacket(JoinedGroupPacket.class);
            this.registerOutgoingPacket(AddCategoryPacket.class);
            this.registerOutgoingPacket(RemoveCategoryPacket.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to register voice chat packets", e);
        }
    }

    public void onDisable() {
        Set incomingChannels = Bukkit.getMessenger().getIncomingChannels((Plugin)Voicechat.INSTANCE);
        Set outgoingChannels = Bukkit.getMessenger().getOutgoingChannels((Plugin)Voicechat.INSTANCE);
        for (String channel : incomingChannels) {
            Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)Voicechat.INSTANCE, channel);
        }
        for (String channel : outgoingChannels) {
            Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)Voicechat.INSTANCE, channel);
        }
        this.packets.clear();
    }

    public Set<String> getPackets() {
        return this.packets;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Set outgoingChannels = Bukkit.getMessenger().getOutgoingChannels((Plugin)Voicechat.INSTANCE);
        for (String channel : outgoingChannels) {
            Voicechat.compatibility.addChannel(event.getPlayer(), channel);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Set outgoingChannels = Bukkit.getMessenger().getOutgoingChannels((Plugin)Voicechat.INSTANCE);
        for (String channel : outgoingChannels) {
            Voicechat.compatibility.removeChannel(event.getPlayer(), channel);
        }
    }

    private <T extends Packet<?>> void registerIncomingPacket(Class<T> packetClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor c = packetClass.getDeclaredConstructor(new Class[0]);
        String id = ((Packet)c.newInstance(new Object[0])).getID().toString();
        this.packets.add(id);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)Voicechat.INSTANCE, id, (s, player, bytes) -> {
            Packet packet;
            try {
                packet = (Packet)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Voicechat.LOGGER.error("Failed to create new packet instance of {}", packetClass.getSimpleName(), e);
                return;
            }
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes));
            packet.fromBytes(buffer);
            packet.onPacket(player);
        });
    }

    private <T extends Packet<?>> void registerOutgoingPacket(Class<T> packetClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String id = ((Packet)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getID().toString();
        this.packets.add(id);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)Voicechat.INSTANCE, id);
    }

    public static void sendToClient(Player player, Packet<?> p) {
        Voicechat.compatibility.runTask(() -> {
            if (!Voicechat.SERVER.isCompatible(player)) {
                return;
            }
            try {
                FriendlyByteBuf buf = new FriendlyByteBuf();
                p.toBytes(buf);
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                player.sendPluginMessage((Plugin)Voicechat.INSTANCE, p.getID().toString(), bytes);
            }
            catch (Exception e) {
                Voicechat.LOGGER.error("Failed to send packet to '{}'", player.getName(), e);
            }
        });
    }

    public static void sendMessage(Player player, String key, String ... args) {
        Voicechat.compatibility.sendTranslationMessage(player, key, args);
    }

    public static void sendStatusMessage(Player player, String key, String ... args) {
        Voicechat.compatibility.sendStatusMessage(player, key, args);
    }
}

