/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.minorcrafts;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.minorcrafts.MinorItems;
import io.github.greatericontop.weaponmaster.utils.Util;
import io.github.greatericontop.weaponmaster.utils.VersionSpecificUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MinorItemListener
implements Listener {
    public final Set<UUID> withers = new HashSet<UUID>();
    private final Random rnd = new Random();
    private final MinorItems minorItems = new MinorItems();
    private final Util util;
    private final WeaponMasterMain plugin;
    private static final double RANGE = 80.0;

    public MinorItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.ELDER_GUARDIAN) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.leviathanHeart")) {
                ItemStack leviathan = this.minorItems.generateLeviathanHeartItemStack();
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), leviathan);
                Player killer = event.getEntity().getKiller();
                if (killer != null) {
                    killer.sendMessage("\u00a7eRARE DROP! " + this.minorItems.LEVIATHAN_HEART_NAME);
                }
            }
        } else if (event.getEntityType() == EntityType.PIGLIN_BRUTE) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.coreStaff")) {
                ItemStack core = this.minorItems.generateCoreStaffItemStack();
                Item coreEntity = event.getEntity().getWorld().dropItemNaturally(event.getEntity().getEyeLocation(), core);
                coreEntity.setInvulnerable(true);
                Player killer = event.getEntity().getKiller();
                if (killer != null) {
                    killer.sendMessage("\u00a7eRARE DROP! " + this.minorItems.CORE_STAFF_NAME);
                }
            }
        } else if (event.getEntityType() == EntityType.CAVE_SPIDER) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.silkyString")) {
                ItemStack silky = this.minorItems.generateSilkyStringItemStack();
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), silky);
                Player killer = event.getEntity().getKiller();
                if (killer != null) {
                    killer.sendMessage("\u00a7eRARE DROP! " + this.minorItems.SILKY_STRING_NAME);
                }
            }
        } else if (event.getEntityType() == EntityType.EVOKER) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.lifeCore")) {
                ItemStack life = this.minorItems.generateLifeCoreItemStack();
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), life);
                Player killer = event.getEntity().getKiller();
                if (killer != null) {
                    killer.sendMessage("\u00a7eRARE DROP! " + this.minorItems.LIFE_CORE_NAME);
                }
            }
        } else if (event.getEntityType() == EntityType.WITHER) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.expertSeal")) {
                ItemStack seal = this.minorItems.generateExpertSealItemStack();
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), seal);
                Player killer = event.getEntity().getKiller();
                if (killer != null) {
                    killer.sendMessage("\u00a7eRARE DROP! " + this.minorItems.EXPERT_SEAL_NAME);
                }
            }
        } else if (event.getEntityType() == EntityType.ENDERMITE && Math.random() < this.plugin.getConfig().getDouble("rng.endArtifact")) {
            ItemStack endArtifact = this.minorItems.generateEndArtifactItemStack();
            event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), endArtifact);
            Player killer = event.getEntity().getKiller();
            if (killer != null) {
                killer.sendMessage("\u00a7eRARE DROP! " + this.minorItems.END_ARTIFACT_NAME);
            }
        }
        if (event.getEntityType() == EntityType.PLAYER) {
            Player player = (Player)event.getEntity();
            VersionSpecificUtil.modifyAttributeModifier(player.getAttribute(Attribute.GENERIC_MAX_HEALTH), this.minorItems.ENERGY_MODIFIER_UUID, -4.0, 0.0, 12.0);
        }
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent event) {
        if (!this.util.checkFor(event.getItem(), 0, "id: MAGIC_ENERGY_BAR")) {
            return;
        }
        Player player = event.getPlayer();
        VersionSpecificUtil.modifyAttributeModifier(player.getAttribute(Attribute.GENERIC_MAX_HEALTH), this.minorItems.ENERGY_MODIFIER_UUID, 2.0, 0.0, 12.0);
        player.sendMessage("\u00a73Successfully gained a heart!");
    }

    @EventHandler
    public void rightClickBlock(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (this.util.checkFor(player.getInventory().getItemInMainHand(), 0, "id: SILKY_STRING") || this.util.checkFor(player.getInventory().getItemInMainHand(), 0, "id: LEVIATHAN_HEART") || this.util.checkFor(player.getInventory().getItemInMainHand(), 0, "id: DRAGON_HORN")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onXPBottleSmash(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof ThrownExpBottle)) {
            return;
        }
        ThrownExpBottle bottle = (ThrownExpBottle)event.getEntity();
        ItemStack item = bottle.getItem();
        if (this.util.checkFor(item, 0, "id: SUPER_XP_BOTTLE")) {
            ExperienceOrb orb = (ExperienceOrb)event.getEntity().getWorld().spawn(event.getEntity().getLocation(), ExperienceOrb.class);
            orb.setExperience(1000 + this.rnd.nextInt(241));
        }
    }

    @EventHandler
    public void onOre(BlockBreakEvent event) {
        if (event.getExpToDrop() == 0) {
            return;
        }
        Material type = event.getBlock().getType();
        if (type == Material.DEEPSLATE_COAL_ORE) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.plutonium")) {
                ItemStack item = this.minorItems.generateCrudePlutoniumItemStack();
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().add(0.5, 0.5, 0.5), item);
                event.getPlayer().sendMessage("\u00a7eRARE DROP! " + this.minorItems.CRUDE_PLUTONIUM_NAME);
            }
        } else if (type == Material.DIAMOND_ORE || type == Material.DEEPSLATE_DIAMOND_ORE) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.diamondApex")) {
                ItemStack item = this.minorItems.generateDiamondApexItemStack();
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().add(0.5, 0.5, 0.5), item);
                event.getPlayer().sendMessage("\u00a7eRARE DROP! " + this.minorItems.DIAMOND_APEX_NAME);
            }
        } else if (type == Material.EMERALD_ORE || type == Material.DEEPSLATE_EMERALD_ORE) {
            if (Math.random() < this.plugin.getConfig().getDouble("rng.emeraldApex")) {
                ItemStack item = this.minorItems.generateEmeraldApexItemStack();
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().add(0.5, 0.5, 0.5), item);
                event.getPlayer().sendMessage("\u00a7eRARE DROP! " + this.minorItems.EMERALD_APEX_NAME);
            }
        } else if ((type == Material.REDSTONE_ORE || type == Material.DEEPSLATE_REDSTONE_ORE) && Math.random() < this.plugin.getConfig().getDouble("rng.redstoneApex")) {
            ItemStack item = this.minorItems.generateRedstoneApexItemStack();
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().add(0.5, 0.5, 0.5), item);
            event.getPlayer().sendMessage("\u00a7eRARE DROP! " + this.minorItems.REDSTONE_APEX_NAME);
        }
    }

    @EventHandler
    public void onWitherSpawn(EntitySpawnEvent event) {
        if (event.getEntityType() != EntityType.WITHER) {
            return;
        }
        final Wither wither = (Wither)event.getEntity();
        this.withers.add(wither.getUniqueId());
        new BukkitRunnable(){

            public void run() {
                if (wither.isDead()) {
                    String name;
                    if (Math.random() < 0.5) {
                        wither.getWorld().dropItemNaturally(wither.getLocation(), MinorItemListener.this.minorItems.generateExpertSealItemStack());
                        name = MinorItemListener.this.minorItems.EXPERT_SEAL_NAME;
                    } else if (Math.random() < 0.5) {
                        wither.getWorld().dropItemNaturally(wither.getLocation(), MinorItemListener.this.minorItems.generateWitherDye());
                        name = MinorItemListener.this.minorItems.WITHER_DYE_NAME;
                    } else {
                        wither.getWorld().dropItemNaturally(wither.getLocation(), MinorItemListener.this.minorItems.generateWitherHeadItemStack());
                        name = MinorItemListener.this.minorItems.WITHER_HEAD_NAME;
                    }
                    if (wither.getKiller() != null) {
                        wither.getKiller().sendMessage("\u00a7eW\u00a7co\u00a7ew\u00a7c! \u00a7bYou are truly an expert! You have been given " + name);
                    }
                    MinorItemListener.this.withers.remove(wither.getUniqueId());
                    this.cancel();
                    return;
                }
                Collection nearbyPlayers = wither.getWorld().getNearbyEntities(wither.getLocation(), 80.0, 80.0, 80.0, e -> e instanceof Player);
                if (nearbyPlayers.isEmpty()) {
                    MinorItemListener.this.withers.remove(wither.getUniqueId());
                    this.cancel();
                    return;
                }
                if (nearbyPlayers.size() > 1) {
                    MinorItemListener.this.withers.remove(wither.getUniqueId());
                    this.cancel();
                    return;
                }
                Player player = (Player)nearbyPlayers.stream().iterator().next();
                ItemStack[] armor = player.getInventory().getArmorContents();
                if (armor[0] != null && armor[0].getType() != Material.AIR || armor[1] != null && armor[1].getType() != Material.AIR || armor[2] != null && armor[2].getType() != Material.AIR || armor[3] != null && armor[3].getType() != Material.AIR) {
                    MinorItemListener.this.withers.remove(wither.getUniqueId());
                    this.cancel();
                    return;
                }
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dy = -3; dy <= 3; ++dy) {
                        for (int dz = -2; dz <= 2; ++dz) {
                            if (wither.getLocation().add((double)dx, (double)dy, (double)dz).getBlock().getType() != Material.BEDROCK) continue;
                            wither.teleport((Entity)player);
                        }
                    }
                }
                if (Math.random() < 0.008 && !wither.hasLineOfSight((Entity)player)) {
                    player.playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
                    player.sendMessage("\u00a7cYou can't hide from me...");
                    wither.teleport((Entity)player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @EventHandler
    public void witherDamageTypeResistance(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.WITHER) {
            return;
        }
        if (!this.withers.contains(event.getEntity().getUniqueId())) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            event.setDamage(event.getDamage() * 0.25);
        }
    }
}

