/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.WitherStaff;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.InaccuracyAdder;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WitherItemListener
implements Listener {
    private final Map<UUID, Boolean> cooldowns = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public WitherItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForWitherStaff(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.witherstaff.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.witherstaff.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        if (!this.cooldowns.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        this.cooldowns.put(player.getUniqueId(), false);
        Vector velocity = player.getLocation().getDirection().normalize().multiply(0.35).add(InaccuracyAdder.generateInaccuracy(0.02));
        WitherSkull witherSkull = (WitherSkull)player.getLocation().getWorld().spawnEntity(player.getEyeLocation(), EntityType.WITHER_SKULL);
        witherSkull.setVelocity(velocity);
        witherSkull.setShooter((ProjectileSource)player);
        witherSkull.setCharged(Math.random() < this.plugin.getConfig().getDouble("witherStaff.chargedChance", 0.06));
        long cooldown = this.plugin.getConfig().getLong("witherStaff.cooldownTicks", 20L);
        if (cooldown > 0L) {
            new BukkitRunnable(){

                public void run() {
                    WitherItemListener.this.cooldowns.put(player.getUniqueId(), true);
                }
            }.runTaskLater((Plugin)this.plugin, cooldown);
        } else {
            this.cooldowns.put(player.getUniqueId(), true);
        }
    }
}

