/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.WitchSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WitchSwordListener
implements Listener {
    private static final double HEAL_FACTOR = 0.15;
    private static final PotionEffect WITCH_EFFECT = new PotionEffect(PotionEffectType.UNLUCK, 200, 100, true, true, true);
    private final WeaponMasterMain plugin;
    private final Util util;

    public WitchSwordListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onPlayerAttackEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForWitchSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.witchsword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.witchsword.use\u00a73.");
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity victim = (LivingEntity)event.getEntity();
        victim.addPotionEffect(WITCH_EFFECT);
        event.setDamage(event.getDamage() * 0.7);
        if (victim instanceof Player) {
            ((Player)victim).playSound(victim.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCursedEntityAttacked(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        LivingEntity victim = (LivingEntity)event.getEntity();
        LivingEntity attacker = (LivingEntity)event.getDamager();
        PotionEffect effect = victim.getPotionEffect(PotionEffectType.UNLUCK);
        if (effect != null && effect.getAmplifier() == WITCH_EFFECT.getAmplifier() && effect.isAmbient()) {
            double maxHealth = attacker.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            double newHealth = attacker.getHealth() + maxHealth * 0.15;
            attacker.setHealth(Math.min(newHealth, maxHealth));
            if (attacker instanceof Player) {
                ((Player)attacker).playSound(attacker.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
    }
}

