/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.ThrowingKnife;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ThrowingKnifeListener
implements Listener {
    private static final double KNIFE_SPEED = 0.5;
    Map<UUID, Boolean> isThrowing = new HashMap<UUID, Boolean>();
    Set<UUID> affectedEntities = new HashSet<UUID>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public ThrowingKnifeListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        new BukkitRunnable(){

            public void run() {
                ThrowingKnifeListener.this.affectedEntities.clear();
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForThrowingKnife(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.throwingknife.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.throwingknife.use\u00a73.");
            return;
        }
        if (this.affectedEntities.contains(event.getEntity().getUniqueId())) {
            return;
        }
        if (this.isThrowing.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage("\u00a77The knife is still in the air! You can't stab someone with it, obviously...");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForThrowingKnife(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.throwingknife.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.throwingknife.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.isThrowing.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage("\u00a77The knife is still in the air! You can't throw another one, obviously...");
            event.setCancelled(true);
            return;
        }
        this.isThrowing.put(player.getUniqueId(), true);
        new BukkitRunnable(){

            public void run() {
                ThrowingKnifeListener.this.isThrowing.put(player.getUniqueId(), false);
            }
        }.runTaskLater((Plugin)this.plugin, 120L);
        final Location origin = player.getEyeLocation().add(player.getLocation().getDirection().multiply(0.5));
        final Vector vector = new Vector(0.0, 0.0, 0.0);
        final Vector toAdd = player.getLocation().getDirection().multiply(0.5);
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                Location loc;
                if (this.i < 120) {
                    Location originalLoc = origin.clone().add(vector);
                    if (this.i < 60) {
                        vector.add(toAdd);
                    } else {
                        vector.subtract(toAdd);
                    }
                    loc = origin.clone().add(vector);
                    RayTraceResult rtxResult = loc.getWorld().rayTraceEntities(originalLoc, vector, 0.5);
                    if (rtxResult != null && rtxResult.getHitEntity() != null && rtxResult.getHitEntity() instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)rtxResult.getHitEntity();
                        ThrowingKnifeListener.this.affectedEntities.add(living.getUniqueId());
                        living.damage(4.0, (Entity)player);
                    }
                } else {
                    this.cancel();
                    return;
                }
                loc.getWorld().spawnParticle(Particle.CRIT, loc, 15, 0.1, 0.1, 0.1, 0.11);
                ++this.i;
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

