/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Scylla;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class ScyllaItemListener
implements Listener {
    private final double HEALTH_THRESHOLD = 8.0;
    private final double MAX_REDUCTION = 0.35;
    private final WeaponMasterMain plugin;
    private final Util util;

    public ScyllaItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    private double getResistanceAmount(Player player, double damage) {
        double health = player.getHealth();
        double closeness = 1.0 - health / 8.0;
        double reduction = Math.pow(closeness, 0.7);
        return reduction * 0.35;
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.util.checkForScylla(player.getInventory().getChestplate())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.scylla.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.scylla.use\u00a73.");
            return;
        }
        if (player.getHealth() <= 8.0) {
            double damageReduction = this.getResistanceAmount(player, event.getDamage());
            event.setDamage(event.getDamage() * (1.0 - damageReduction));
            player.sendMessage(String.format("\u00a77[Last Wind] Reduced by %.1f%% to %.1f.", damageReduction * 100.0, event.getDamage()));
        }
    }
}

