/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.ScorpionBow;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ScorpionItemListener
implements Listener {
    private final Set<UUID> arrows = new HashSet<UUID>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public ScorpionItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.util.checkForScorpionBow(event.getBow())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.scorpionbow.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.artemisbow.use\u00a73.");
            return;
        }
        if ((double)event.getForce() < 0.99) {
            player.sendMessage("\u00a77Poison requires a fully charged shot!");
            return;
        }
        this.arrows.add(event.getProjectile().getUniqueId());
    }

    @EventHandler
    public void onArrowHit(EntityDamageByEntityEvent event) {
        if (!this.arrows.contains(event.getDamager().getUniqueId())) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity) {
            ((LivingEntity)event.getEntity()).addPotionEffect(new PotionEffect(PotionEffectType.POISON, 120, 0));
        }
        this.arrows.remove(event.getDamager().getUniqueId());
    }
}

