/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Helios;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class HeliosItemListener
implements Listener {
    private final double IMPACT_DISTANCE = 5.0;
    private final double IMPACT_DISTANCE_SQUARED = 25.0;
    private final float FOOD_COST = 2.6666667f;
    private final int MAX_DAMAGE_LEVEL = 80;
    private final double DAMAGE_INCREASE_PER_LEVEL = 0.00625;
    private final WeaponMasterMain plugin;
    private final Util util;

    public HeliosItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    private double damageMultiply(Player player, double damage) {
        double multiplier = 0.00625 * (double)Math.min(player.getLevel(), 80);
        return damage * (1.0 + multiplier);
    }

    private double distanceSquaredXZ(Location loc1, Location loc2) {
        double deltaX = loc1.getX() - loc2.getX();
        double deltaZ = loc1.getZ() - loc2.getZ();
        return deltaX * deltaX + deltaZ * deltaZ;
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForHelios(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.helios.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.helios.use\u00a73.");
            return;
        }
        event.setDamage(this.damageMultiply(player, event.getDamage()));
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack helios = player.getInventory().getItemInMainHand();
        if (!this.util.checkForHelios(helios)) {
            return;
        }
        if (!player.hasPermission("weaponmaster.helios.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.helios.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        if (player.getFoodLevel() < 12 && player.getGameMode() != GameMode.CREATIVE) {
            player.sendMessage("\u00a77You don't have enough hunger to use this!");
            return;
        }
        Location loc = player.getLocation();
        List entitiesClose = player.getNearbyEntities(5.0, 5.0, 5.0);
        for (Entity e : entitiesClose) {
            if (!(e instanceof LivingEntity) || this.distanceSquaredXZ(loc, e.getLocation()) > 25.0) continue;
            LivingEntity target = (LivingEntity)e;
            double damage = 5.0 + (double)helios.getItemMeta().getEnchantLevel(Enchantment.SHARPNESS) * 0.25;
            double dmg = this.plugin.minorItemListener.withers.contains(target.getUniqueId()) ? this.damageMultiply(player, damage) * 0.4 : this.damageMultiply(player, damage);
            target.damage(dmg, (Entity)player);
            target.setFireTicks(target.getFireTicks() + 200);
            target.setVelocity(target.getVelocity().add(new Vector(0.0, 0.4, 0.0)));
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            player.setExhaustion(player.getExhaustion() + 2.6666667f);
        }
        for (int step = 0; step < 280; ++step) {
            double theta = Math.PI * (double)step / 140.0;
            double deltaX = 5.0 * Math.cos(theta);
            double deltaY = 5.0 * Math.sin(theta);
            loc.getWorld().spawnParticle(Particle.FLAME, loc.clone().add(deltaX, 0.0, deltaY), 1, 0.0, 0.0, 0.0, 0.001);
        }
    }
}

