/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Excalibur;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.TrueDamageHelper;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ExcaliburItemListener
implements Listener {
    private Map<UUID, Boolean> cooldowns = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public ExcaliburItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        final Player player = (Player)event.getDamager();
        if (!this.util.checkForExcalibur(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.excalibur.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.excalibur.use\u00a73.");
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        final LivingEntity victim = (LivingEntity)event.getEntity();
        if (this.cooldowns.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            new BukkitRunnable(){

                public void run() {
                    if (victim.isDead()) {
                        this.cancel();
                        return;
                    }
                    victim.getWorld().createExplosion(victim.getLocation(), 0.0f);
                    victim.getWorld().spawnParticle(Particle.EXPLOSION, victim.getLocation(), 4);
                    TrueDamageHelper.dealTrueDamage(victim, 3.0);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
            this.cooldowns.put(player.getUniqueId(), false);
            new BukkitRunnable(){

                public void run() {
                    ExcaliburItemListener.this.cooldowns.put(player.getUniqueId(), true);
                }
            }.runTaskLater((Plugin)this.plugin, 120L);
        }
    }
}

