/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.DragonSword.DragonSwordUpgradeListener;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DragonSwordListener
implements Listener {
    private final double A = 0.0;
    private final double B = 0.8;
    private final double C = 0.25;
    private final WeaponMasterMain plugin;
    private final Util util;
    private final DragonSwordUpgradeListener dragonUpgrade;

    public DragonSwordListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.dragonUpgrade = new DragonSwordUpgradeListener(plugin);
    }

    private double triangular(double random) {
        double F = 0.3125;
        if (random < F) {
            return 0.0 + Math.sqrt(random * 0.8 * 0.25);
        }
        return 0.8 - Math.sqrt((1.0 - random) * 0.8 * 0.55);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForDragonSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.dragonsword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.dragonsword.use\u00a73.");
            return;
        }
        if (Math.random() < this.dragonUpgrade.abilityTriggerProbability(player.getInventory().getItemInMainHand().getItemMeta().getLore())) {
            double multiplier = 1.0 + this.triangular(Math.random());
            if (this.util.checkForDragonArmor(player.getInventory().getHelmet()) && this.util.checkForDragonArmor(player.getInventory().getChestplate()) && this.util.checkForDragonArmor(player.getInventory().getLeggings()) && this.util.checkForDragonArmor(player.getInventory().getBoots())) {
                multiplier *= 1.15;
            }
            event.setDamage(event.getDamage() * multiplier);
            this.plugin.paperUtils.sendActionBar(player, String.format("\u00a73Hit increased by \u00a74%.1f%% \u00a73for \u00a74%.1f\u00a73.", (multiplier - 1.0) * 100.0, event.getDamage()), true);
        }
    }
}

