/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragondescent;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DescentManagementCommand
implements CommandExecutor {
    private final WeaponMasterMain plugin;

    public DescentManagementCommand(WeaponMasterMain plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cPlayers only, sorry!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            return false;
        }
        if (args[0].equals("give-power")) {
            int power;
            if (args.length < 2) {
                player.sendMessage("\u00a7cError: \u00a74Missing arguments: /descent-management give-power <power> [<shards>]");
                return true;
            }
            try {
                power = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cError: \u00a74Invalid number!");
                return true;
            }
            int shards = 0;
            if (args.length >= 3) {
                try {
                    shards = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cError: \u00a74Invalid number!");
                    return true;
                }
            }
            this.plugin.descent.setDragonPower(player.getUniqueId(), this.plugin.descent.getDragonPower(player.getUniqueId()) + power);
            this.plugin.descent.setShards(player.getUniqueId(), this.plugin.descent.getShards(player.getUniqueId()) + shards);
            player.sendMessage(String.format("\u00a73Gave you %d power and %d shards!", power, shards));
            return true;
        }
        if (args[0].equals("clear")) {
            this.plugin.descent.clear(player.getUniqueId());
            player.sendMessage("\u00a73Cleared your descent data!");
            return true;
        }
        return false;
    }
}

