/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragondescent;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.dragondescent.DescentDataManager;
import io.github.greatericontop.weaponmaster.utils.MathHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class DescentEvents
implements Listener {
    private final Map<UUID, Boolean> heartbleedCooldown = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final DescentDataManager descent;
    private final List<Material> ARMOR_MATERIALS = Arrays.asList(Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS);

    public DescentEvents(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.descent = plugin.descent;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageEvent event) {
        int strongLegs;
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        int allDamageResistance = this.descent.getUpgrade(player, "allDamageResistance");
        if (allDamageResistance > 0) {
            double multi = 1.0 - 0.005 * (double)allDamageResistance;
            event.setDamage(event.getDamage() * multi);
        }
        if ((strongLegs = this.descent.getUpgrade(player, "strongLegs")) > 0 && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            double multi = 1.0 - 0.15 * (double)strongLegs;
            event.setDamage(event.getDamage() * multi);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamagePlayer(EntityDamageByEntityEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        int mightyStrength = this.descent.getUpgrade(player, "mightyStrength");
        if (mightyStrength > 0) {
            double activationChance = 0.001 * (double)mightyStrength;
            if (Math.random() < activationChance) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 100, 0, true));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDamageEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        int strongAttacks = this.descent.getUpgrade(player, "strongAttacks");
        if (strongAttacks > 0) {
            double multi = 1.0 + 0.005 * (double)strongAttacks;
            event.setDamage(event.getDamage() * multi);
        }
        if (event.getEntity() instanceof LivingEntity) {
            int grimTouch;
            int sicklyTouch;
            LivingEntity target = (LivingEntity)event.getEntity();
            int silkyTouch = this.descent.getUpgrade(player, "silkyTouch");
            if (silkyTouch > 0) {
                double activationChance = 0.003 * (double)silkyTouch;
                if (Math.random() < activationChance) {
                    target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 0, true));
                }
            }
            if ((sicklyTouch = this.descent.getUpgrade(player, "sicklyTouch")) > 0) {
                double activationChance = 0.003 * (double)sicklyTouch;
                if (Math.random() < activationChance) {
                    target.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 0, true));
                }
            }
            if ((grimTouch = this.descent.getUpgrade(player, "grimTouch")) > 0) {
                double activationChance = 0.003 * (double)grimTouch;
                if (Math.random() < activationChance) {
                    target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 100, 0, true));
                }
            }
        }
    }

    @EventHandler
    public void onEntityKilledByPlayer(EntityDeathEvent event) {
        int heartbleed;
        if (event.getEntity().getKiller() == null) {
            return;
        }
        final Player player = event.getEntity().getKiller();
        int vitality = this.descent.getUpgrade(player, "vitality");
        if (vitality > 0) {
            int ticks = 20 * vitality;
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, ticks, 0, true));
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, ticks, 0, true));
        }
        if ((heartbleed = this.descent.getUpgrade(player, "heartbleed")) > 0) {
            double activationChance = 0.2 * (double)heartbleed;
            if (this.heartbleedCooldown.getOrDefault(player.getUniqueId(), true).booleanValue() && Math.random() < activationChance) {
                double maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                double newHealth = Math.min(maxHealth, player.getHealth() + 1.0);
                player.setHealth(newHealth);
                this.heartbleedCooldown.put(player.getUniqueId(), false);
                new BukkitRunnable(){

                    public void run() {
                        DescentEvents.this.heartbleedCooldown.put(player.getUniqueId(), true);
                    }
                }.runTaskLater((Plugin)this.plugin, 40L);
            }
        }
    }

    @EventHandler
    public void onDurability(PlayerItemDamageEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        int shieldedArmor = this.descent.getUpgrade(player, "shieldedArmor");
        if (shieldedArmor > 0 && this.ARMOR_MATERIALS.contains(item.getType())) {
            double multi = 1.0 - 0.015 * (double)shieldedArmor;
            int newDamage = MathHelper.roundProbability((double)event.getDamage() * multi);
            event.setDamage(newDamage);
        }
    }

    @EventHandler
    public void onPotion(EntityPotionEffectEvent event) {
        PotionEffect eventEffect;
        int reviver;
        PotionEffect extendedEffect;
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        int witch = this.descent.getUpgrade(player, "witch");
        if (witch > 0 && (event.getAction() == EntityPotionEffectEvent.Action.ADDED || event.getAction() == EntityPotionEffectEvent.Action.CHANGED) && event.getCause() == EntityPotionEffectEvent.Cause.POTION_DRINK) {
            PotionEffect eventEffect2 = event.getNewEffect();
            double multi = 1.0 + 0.025 * (double)witch;
            int newDuration = MathHelper.roundProbability((double)eventEffect2.getDuration() * multi);
            extendedEffect = new PotionEffect(eventEffect2.getType(), newDuration, eventEffect2.getAmplifier(), eventEffect2.isAmbient(), eventEffect2.hasParticles(), eventEffect2.hasIcon());
            event.setCancelled(true);
            player.addPotionEffect(extendedEffect);
        }
        if ((reviver = this.descent.getUpgrade(player, "reviver")) > 0 && event.getAction() == EntityPotionEffectEvent.Action.ADDED && event.getCause() == EntityPotionEffectEvent.Cause.TOTEM && (eventEffect = event.getNewEffect()).getType().getId() == PotionEffectType.REGENERATION.getId()) {
            if (eventEffect.getDuration() != 900) {
                this.plugin.getLogger().warning("Regeneration effect from totem is not 900t/45s (likely due to an update)! Please nag us about it!");
            }
            int strongDuration = 12 * reviver;
            int extendDuration = strongDuration + 900 + 60 * reviver;
            extendedEffect = new PotionEffect(PotionEffectType.REGENERATION, extendDuration, 1, eventEffect.isAmbient(), eventEffect.hasParticles(), eventEffect.hasIcon());
            PotionEffect strongEffect = new PotionEffect(PotionEffectType.REGENERATION, strongDuration, 2, eventEffect.isAmbient(), eventEffect.hasParticles(), eventEffect.hasIcon());
            event.setCancelled(true);
            player.addPotionEffect(extendedEffect);
            player.addPotionEffect(strongEffect);
        }
    }

    @EventHandler
    public void onHunger(EntityExhaustionEvent event) {
        Player player = (Player)event.getEntity();
        int enhancedEnergy = this.descent.getUpgrade(player, "enhancedEnergy");
        if (enhancedEnergy > 0) {
            float multi = 1.0f - 0.02f * (float)enhancedEnergy;
            event.setExhaustion(event.getExhaustion() * multi);
        }
    }

    @EventHandler
    public void onPlayerExperienceGain(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        int wisdom = this.descent.getUpgrade(player, "wisdom");
        if (wisdom > 0) {
            double multi = 1.0 + 0.04 * (double)wisdom;
            double newAmount = (double)event.getAmount() * multi;
            event.setAmount(MathHelper.roundProbability(newAmount));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileDamageEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)event.getDamager();
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        int strongArrows = this.descent.getUpgrade(player, "strongArrows");
        if (strongArrows > 0 && event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            double multi = 1.0 + 0.01 * (double)strongArrows;
            event.setDamage(event.getDamage() * multi);
        }
    }
}

