/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.utils;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;

public class VersionSpecificUtil {
    public static void modifyAttributeModifier(AttributeInstance instance, UUID withUUID, double amountDelta, double min, double max) {
        String rawVersion = Bukkit.getServer().getBukkitVersion();
        String minecraftVersion = rawVersion.split("-")[0];
        int major = Integer.parseInt(minecraftVersion.split("\\.")[1]);
        if (major >= 21) {
            VersionSpecificUtil.modifyAttributeModifierNew(instance, withUUID, amountDelta, min, max);
        } else {
            VersionSpecificUtil.modifyAttributeModifierOld(instance, withUUID, amountDelta, min, max);
        }
    }

    private static void modifyAttributeModifierNew(AttributeInstance instance, UUID withUUID, double amountDelta, double min, double max) {
        AttributeModifier newAM;
        String stringKey = withUUID.toString();
        AttributeModifier savedAM = null;
        double amount = 0.0;
        for (AttributeModifier am : instance.getModifiers()) {
            if (!am.getKey().getKey().equals(stringKey)) continue;
            double oldAmount = am.getAmount();
            amount = Math.min(Math.max(oldAmount + amountDelta, min), max);
            savedAM = am;
            break;
        }
        if (savedAM == null) {
            newAM = new AttributeModifier(new NamespacedKey("weaponmaster", stringKey), Math.min(Math.max(amountDelta, min), max), AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
        } else {
            instance.removeModifier(savedAM);
            newAM = new AttributeModifier(new NamespacedKey("weaponmaster", stringKey), amount, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
        }
        instance.addModifier(newAM);
    }

    private static void modifyAttributeModifierOld(AttributeInstance instance, UUID withUUID, double amountDelta, double min, double max) {
        AttributeModifier newAM;
        AttributeModifier savedAM = null;
        double amount = 0.0;
        for (AttributeModifier am : instance.getModifiers()) {
            if (!am.getUniqueId().equals(withUUID)) continue;
            double oldAmount = am.getAmount();
            amount = Math.min(Math.max(oldAmount + amountDelta, min), max);
            savedAM = am;
            break;
        }
        if (savedAM == null) {
            newAM = new AttributeModifier(withUUID, "weaponmaster", Math.min(Math.max(amountDelta, min), max), AttributeModifier.Operation.ADD_NUMBER);
        } else {
            instance.removeModifier(savedAM);
            newAM = new AttributeModifier(withUUID, "weaponmaster", amount, AttributeModifier.Operation.ADD_NUMBER);
        }
        instance.addModifier(newAM);
    }
}

