/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.WitherKingStaff;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.InaccuracyAdder;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WitherKingItemListener
implements Listener {
    private final Map<UUID, Boolean> cooldowns = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> healCooldowns = new HashMap<UUID, Boolean>();
    private final double SHIELD_AMOUNT;
    private final double CHARGE_CHANCE;
    private final long FIRE_COOLDOWN_TICKS;
    private final long SHIELD_DECAY_AFTER;
    private final long SHIELD_COOLDOWN_TICKS;
    private final WeaponMasterMain plugin;
    private final Util util;

    public WitherKingItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.SHIELD_AMOUNT = plugin.getConfig().getDouble("witherStaff.kingShieldAmount", 10.0);
        this.CHARGE_CHANCE = plugin.getConfig().getDouble("witherStaff.chargedChance", 0.06);
        this.FIRE_COOLDOWN_TICKS = plugin.getConfig().getLong("witherStaff.cooldownTicksUpgraded", 4L);
        this.SHIELD_DECAY_AFTER = plugin.getConfig().getLong("witherStaff.shieldDecayAfter", 200L);
        this.SHIELD_COOLDOWN_TICKS = plugin.getConfig().getLong("witherStaff.shieldCooldownTicks", 300L);
    }

    private AttributeModifier getAM() {
        return new AttributeModifier(new NamespacedKey("weaponmaster", "wither_king"), this.SHIELD_AMOUNT, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForWitherKingStaff(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.witherkingstaff.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.witherkingstaff.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (!this.cooldowns.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        this.cooldowns.put(player.getUniqueId(), false);
        Vector velocity = player.getLocation().getDirection().normalize().multiply(0.455).add(InaccuracyAdder.generateInaccuracy(0.026));
        WitherSkull witherSkull = (WitherSkull)player.getLocation().getWorld().spawnEntity(player.getEyeLocation(), EntityType.WITHER_SKULL);
        witherSkull.setVelocity(velocity);
        witherSkull.setShooter((ProjectileSource)player);
        witherSkull.setCharged(Math.random() < this.CHARGE_CHANCE);
        if (this.FIRE_COOLDOWN_TICKS > 0L) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.cooldowns.put(player.getUniqueId(), true), this.FIRE_COOLDOWN_TICKS);
        } else {
            this.cooldowns.put(player.getUniqueId(), true);
        }
    }

    @EventHandler
    public void onRightClickHeal(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForWitherKingStaff(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.witherkingstaff.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.witherkingstaff.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!this.healCooldowns.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        this.healCooldowns.put(player.getUniqueId(), false);
        player.removePotionEffect(PotionEffectType.ABSORPTION);
        if (!player.getAttribute(Attribute.GENERIC_MAX_ABSORPTION).getModifiers().contains(this.getAM())) {
            player.getAttribute(Attribute.GENERIC_MAX_ABSORPTION).addModifier(this.getAM());
        }
        player.setAbsorptionAmount(this.SHIELD_AMOUNT);
        player.playSound(player.getLocation(), Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.0f, 1.0f);
        new BukkitRunnable(){

            public void run() {
                player.getAttribute(Attribute.GENERIC_MAX_ABSORPTION).removeModifier(WitherKingItemListener.this.getAM());
                if (player.getPotionEffect(PotionEffectType.ABSORPTION) == null) {
                    double absorptionAmount = player.getAbsorptionAmount();
                    player.setAbsorptionAmount(0.0);
                    player.setHealth(Math.min(player.getHealth() + absorptionAmount * 0.5, player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
                }
            }
        }.runTaskLater((Plugin)this.plugin, this.SHIELD_DECAY_AFTER);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.healCooldowns.put(player.getUniqueId(), true), this.SHIELD_COOLDOWN_TICKS);
    }

    @EventHandler
    public void onAbsorption(EntityPotionEffectEvent event) {
        double currentAbsorption;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.getAttribute(Attribute.GENERIC_MAX_ABSORPTION).getModifiers().contains(this.getAM()) || this.healCooldowns.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        if (event.getAction() != EntityPotionEffectEvent.Action.ADDED || event.getNewEffect().getType() != PotionEffectType.ABSORPTION) {
            return;
        }
        double heartsToAdd = 4.0 * (double)(event.getNewEffect().getAmplifier() + 1);
        if (heartsToAdd <= (currentAbsorption = player.getAbsorptionAmount())) {
            player.sendMessage("\u00a77Prevented your weaker absorption effect from overwriting your Wither King Staff!");
            event.setCancelled(true);
        }
    }
}

