/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Scylla;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class ScyllaItemListener
implements Listener {
    private final double HEALTH_THRESHOLD;
    private final double MAX_REDUCTION;
    private final WeaponMasterMain plugin;
    private final Util util;

    public ScyllaItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.HEALTH_THRESHOLD = plugin.getConfig().getDouble("scylla.health_threshold", 8.0);
        this.MAX_REDUCTION = plugin.getConfig().getDouble("scylla.max_reduction", 0.35);
    }

    private double getResistanceAmount(Player player, double damage) {
        double health = player.getHealth();
        double closeness = 1.0 - health / this.HEALTH_THRESHOLD;
        double reduction = Math.pow(closeness, 0.7);
        return reduction * this.MAX_REDUCTION;
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.util.checkForScylla(player.getInventory().getChestplate())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.scylla.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.scylla.use\u00a73.");
            return;
        }
        if (player.getHealth() <= this.HEALTH_THRESHOLD) {
            double damageReduction = this.getResistanceAmount(player, event.getDamage());
            event.setDamage(event.getDamage() * (1.0 - damageReduction));
            player.sendMessage(String.format("\u00a77[Last Wind] Reduced by %.1f%% to %.1f.", damageReduction * 100.0, event.getDamage()));
        }
    }
}

