/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.PilotSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PilotItemListener
implements Listener {
    private final double DAMAGE_MULTIPLIER;
    private final WeaponMasterMain plugin;
    private final Util util;

    public PilotItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.DAMAGE_MULTIPLIER = plugin.getConfig().getDouble("pilot.damage_multiplier", 0.111111111111111);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForPilotSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.pilotsword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.pilotsword.use\u00a73.");
            return;
        }
        event.setDamage(event.getDamage() * this.DAMAGE_MULTIPLIER);
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        final LivingEntity victim = (LivingEntity)event.getEntity();
        new BukkitRunnable(){

            public void run() {
                if (victim.isDead()) {
                    this.cancel();
                    return;
                }
                victim.setNoDamageTicks(0);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }
}

