/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.MinerBlessing;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.MinerBlessing.MinerUtil;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class MinerItemListener
extends MinerUtil
implements Listener {
    final Material[] stoneMats = new Material[]{Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.REDSTONE_ORE, Material.LAPIS_ORE};
    final Material[] deepMats = new Material[]{Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_LAPIS_ORE};
    final Material[] netherMats = new Material[]{Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS};
    private final double REPAIR_PENALTY = 0.14285714285714285;
    private Map<UUID, Boolean> cooldown = new HashMap<UUID, Boolean>();
    private final int RANGE = 3;

    public MinerItemListener(WeaponMasterMain plugin) {
        super(plugin);
    }

    public void runLevelUp(int newTier, ItemMeta im, List<String> lore) {
        switch (newTier) {
            case 1: {
                im.addEnchant(Enchantment.EFFICIENCY, 1, false);
                lore.add(this.util.MINER_INSERTION, "\u00a7eEfficiency I");
                break;
            }
            case 2: {
                im.removeEnchant(Enchantment.EFFICIENCY);
                im.addEnchant(Enchantment.EFFICIENCY, 2, false);
                lore.set(this.util.MINER_INSERTION, "\u00a7eEfficiency II");
                break;
            }
            case 3: {
                im.removeEnchant(Enchantment.EFFICIENCY);
                im.addEnchant(Enchantment.EFFICIENCY, 3, false);
                im.addEnchant(Enchantment.UNBREAKING, 1, false);
                lore.set(this.util.MINER_INSERTION, "\u00a7eEfficiency III, Unbreaking I");
                break;
            }
            case 4: {
                im.removeEnchant(Enchantment.EFFICIENCY);
                im.addEnchant(Enchantment.EFFICIENCY, 4, false);
                im.addEnchant(Enchantment.SHARPNESS, 1, true);
                lore.set(this.util.MINER_INSERTION, "\u00a7eEfficiency IV, Unbreaking I, Sharpness I");
                break;
            }
            case 5: {
                im.removeEnchant(Enchantment.EFFICIENCY);
                im.removeEnchant(Enchantment.UNBREAKING);
                im.removeEnchant(Enchantment.SHARPNESS);
                im.addEnchant(Enchantment.EFFICIENCY, 5, false);
                im.addEnchant(Enchantment.UNBREAKING, 2, false);
                im.addEnchant(Enchantment.SHARPNESS, 2, true);
                lore.set(this.util.MINER_INSERTION, "\u00a7eEfficiency V, Unbreaking II, Sharpness II");
                break;
            }
            case 6: {
                im.removeEnchant(Enchantment.UNBREAKING);
                im.removeEnchant(Enchantment.SHARPNESS);
                im.addEnchant(Enchantment.UNBREAKING, 3, false);
                im.addEnchant(Enchantment.SHARPNESS, 3, true);
                lore.set(this.util.MINER_INSERTION, "\u00a7eEfficiency V, Unbreaking III, Sharpness III");
                break;
            }
            case 7: {
                lore.add(this.util.MINER_INSERTION + 1, "");
                lore.add(this.util.MINER_INSERTION + 2, "\u00a73RIGHT CLICK to cycle between different modes. \u00a77\u00a7oTIER 7");
                lore.add(this.util.MINER_INSERTION + 3, "\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a77none");
                break;
            }
            case 8: {
                lore.add(this.util.MINER_INSERTION + 4, "");
                lore.add(this.util.MINER_INSERTION + 5, "\u00a7aAutomatically smelts some ores and drops additional experience. \u00a77\u00a7oTIER 8");
                lore.add(this.util.MINER_INSERTION + 6, "\u00a77Fortune cannot be used in this mode.");
                break;
            }
            case 9: {
                lore.add(this.util.MINER_INSERTION + 7, "\u00a7dWhen breaking some deepslate ores while not in Silk Touch");
                lore.add(this.util.MINER_INSERTION + 8, "\u00a7dmode, gain a \u00a741% \u00a7dchance to drop a block instead. \u00a77\u00a7oTIER 9");
                break;
            }
            case 10: {
                lore.set(this.util.MINER_INSERTION + 6, "\u00a7aFortune III applies to this mode and smelted ores. \u00a77\u00a7oTIER 10");
                break;
            }
            case 11: {
                lore.add(this.util.MINER_INSERTION + 9, "\u00a72Small chance for ores to spawn around you. \u00a77\u00a7oTIER 11");
                break;
            }
            case 12: {
                lore.add(this.util.MINER_INSERTION + 10, "\u00a7fIncreased Mending power, no longer limited \u00a77\u00a7oTIER 12");
                break;
            }
            case 13: {
                lore.add(this.util.MINER_INSERTION + 11, "\u00a7ePermanent \u00a7e\u00a7lHaste I \u00a7ewhile holding. \u00a77\u00a7oTIER 13");
                break;
            }
            case 14: {
                lore.add(this.util.MINER_INSERTION + 12, "\u00a7cArea Mine: Destroy blocks nearby (25s cooldown) \u00a77\u00a7oTIER 14");
                break;
            }
            case 15: {
                lore.set(this.util.MINER_INSERTION + 8, "\u00a7dmode, gain a \u00a743.5% \u00a7dchance to drop a block instead. \u00a77\u00a7oTIER \u00a7m9\u00a7r\u00a77\u00a7o 15");
                lore.set(this.util.MINER_INSERTION + 12, "\u00a7cArea Mine: Destroy blocks nearby (20s cooldown) \u00a77\u00a7oTIER \u00a7m14\u00a7r\u00a77\u00a7o 15");
                break;
            }
            case 16: {
                lore.set(this.util.MINER_INSERTION + 8, "\u00a7dmode, gain a \u00a744.5% \u00a7dchance to drop a block instead. \u00a77\u00a7oTIER \u00a7m9 15\u00a7r\u00a77\u00a7o 16");
                lore.set(this.util.MINER_INSERTION + 12, "\u00a7cArea Mine: Destroy blocks nearby (15s cooldown) \u00a77\u00a7oTIER \u00a7m14 15\u00a7r\u00a77\u00a7o 16");
                lore.set(this.util.MINER_INSERTION + 13, "\u00a7f----- \u00a72This tier \u00a7416 \u00a72pickaxe is fully upgraded! \u00a7f-----");
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!this.util.checkForMinersBlessing(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.minersblessing.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.minersblessing.use\u00a73.");
            return;
        }
        ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
        List lore = im.getLore();
        int amount = this.xpToAdd(event.getBlock().getType(), lore);
        Objects.requireNonNull(this.util);
        int exp = this.parseExpInt((String)lore.get(3));
        Objects.requireNonNull(this.util);
        int tier = this.parseLevelInt((String)lore.get(5));
        if ((exp += amount) >= this.getRequirementToLevelUp(tier)) {
            exp = 0;
            this.runLevelUp(++tier, im, lore);
            player.sendMessage(String.format("\u00a79Your %s \u00a79is now level \u00a76%d.", this.util.MINERS_BLESSING_NAME, tier));
            Objects.requireNonNull(this.util);
            lore.set(5, String.format("\u00a76Tier: \u00a7b%d", tier));
        }
        Objects.requireNonNull(this.util);
        lore.set(3, String.format("\u00a76Experience: \u00a7b%d", exp));
        double xpPercent = 100.0 * (double)exp / (double)this.getRequirementToLevelUp(tier);
        Objects.requireNonNull(this.util);
        lore.set(4, String.format("\u00a76Required: \u00a7b%d \u00a76(\u00a7b%.1f\u00a76%%)", this.getRequirementToLevelUp(tier), xpPercent));
        this.plugin.paperUtils.sendActionBar(player, String.format("\u00a72\u00a7o+%d  \u00a7r\u00a77|  \u00a76Experience: \u00a7b%d\u00a76/\u00a7b%d \u00a76(\u00a7b%.1f\u00a76%%)", amount, exp, this.getRequirementToLevelUp(tier), xpPercent), false);
        if (tier >= 8 && this.getMode(lore).equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Smelting Touch")) {
            this.doSmeltingOres(event, player, im.getEnchantLevel(Enchantment.FORTUNE));
        }
        if (tier >= 9) {
            this.doDeepslateBlockMultiply(event, player, lore, tier);
        }
        if (tier >= 11) {
            this.attemptSpawnBlock(event, player);
        }
        if (tier >= 14 && this.getMode(lore).equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Area Mine")) {
            this.areaBlockBreak(event.getBlock().getLocation(), player, player.getInventory().getItemInMainHand(), (Damageable)im, tier);
        }
        this.fixEnchants(tier, im, player);
        im.setLore(lore);
        player.getInventory().getItemInMainHand().setItemMeta(im);
    }

    public void doSmeltingOres(BlockBreakEvent event, Player player, int hasFortune) {
        Material mat = event.getBlock().getType();
        World world = event.getBlock().getLocation().getWorld();
        Location dropLocation = event.getBlock().getLocation().add(0.5, 0.5, 0.5);
        if (mat == Material.COPPER_ORE || mat == Material.DEEPSLATE_COPPER_ORE) {
            event.setDropItems(false);
            int amount = this.doFortuneOre(this.rnd.nextInt(3) + 2, hasFortune);
            world.dropItemNaturally(dropLocation, new ItemStack(Material.COPPER_INGOT, amount));
            event.setExpToDrop(3 * amount);
        } else if (mat == Material.IRON_ORE || mat == Material.DEEPSLATE_IRON_ORE) {
            event.setDropItems(false);
            int amount = this.doFortuneOre(1, hasFortune);
            world.dropItemNaturally(dropLocation, new ItemStack(Material.IRON_INGOT, amount));
            event.setExpToDrop(3 * amount);
        } else if (mat == Material.GOLD_ORE || mat == Material.DEEPSLATE_GOLD_ORE) {
            event.setDropItems(false);
            int amount = this.doFortuneOre(1, hasFortune);
            world.dropItemNaturally(dropLocation, new ItemStack(Material.GOLD_INGOT, amount));
            event.setExpToDrop(5 * amount);
        } else if (mat == Material.ANCIENT_DEBRIS) {
            event.setDropItems(false);
            world.dropItemNaturally(dropLocation, new ItemStack(Material.NETHERITE_SCRAP, 1));
            event.setExpToDrop(14);
        } else if (mat == Material.STONE) {
            event.setDropItems(false);
            world.dropItemNaturally(dropLocation, new ItemStack(Material.SMOOTH_STONE, 1));
        }
    }

    public void doDeepslateBlockMultiply(BlockBreakEvent event, Player player, List<String> lore, int tier) {
        float f = this.rnd.nextFloat();
        float f2 = tier >= 15 ? (tier >= 16 ? 0.045f : 0.035f) : 0.01f;
        if (f >= f2) {
            return;
        }
        if (this.getMode(lore).equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Silk Touch")) {
            return;
        }
        World world = event.getBlock().getLocation().getWorld();
        event.setExpToDrop(event.getExpToDrop() * 9);
        switch (event.getBlock().getType()) {
            case DEEPSLATE_COAL_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.COAL_BLOCK, 1));
                break;
            }
            case DEEPSLATE_COPPER_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.COPPER_BLOCK, 1));
                break;
            }
            case DEEPSLATE_IRON_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.IRON_BLOCK, 1));
                break;
            }
            case DEEPSLATE_GOLD_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.GOLD_BLOCK, 1));
                break;
            }
            case DEEPSLATE_EMERALD_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.EMERALD_BLOCK, 1));
                break;
            }
            case DEEPSLATE_REDSTONE_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.REDSTONE_BLOCK, 1));
                break;
            }
            case DEEPSLATE_LAPIS_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.LAPIS_BLOCK, 1));
                break;
            }
            case DEEPSLATE_DIAMOND_ORE: {
                world.dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.DIAMOND_BLOCK, 1));
                break;
            }
        }
    }

    public void attemptSpawnBlock(BlockBreakEvent event, Player player) {
        Location loc = event.getBlock().getLocation();
        this.attemptSpawnBlockSingle(loc.clone().add(1.0, 0.0, 0.0), player, event.getBlock().getType());
        this.attemptSpawnBlockSingle(loc.clone().add(-1.0, 0.0, 0.0), player, event.getBlock().getType());
        this.attemptSpawnBlockSingle(loc.clone().add(0.0, 1.0, 0.0), player, event.getBlock().getType());
        this.attemptSpawnBlockSingle(loc.clone().add(0.0, -1.0, 0.0), player, event.getBlock().getType());
        this.attemptSpawnBlockSingle(loc.clone().add(0.0, 0.0, 1.0), player, event.getBlock().getType());
        this.attemptSpawnBlockSingle(loc.clone().add(0.0, 0.0, -1.0), player, event.getBlock().getType());
    }

    private void attemptSpawnBlockSingle(Location loc, Player player, Material blockType) {
        Block blockAt = loc.getBlock();
        if (blockAt.getType() == Material.STONE && (blockType == Material.STONE || blockType == Material.ANDESITE || blockType == Material.DIORITE || blockType == Material.GRANITE)) {
            if (this.rnd.nextFloat() >= 0.0015f) {
                return;
            }
            Material replacement = this.stoneMats[this.rnd.nextInt(this.stoneMats.length)];
            blockAt.setType(replacement);
            player.sendMessage("\u00a77A new ore just spawned!");
        } else if (blockAt.getType() == Material.DEEPSLATE && blockType == Material.DEEPSLATE) {
            if (this.rnd.nextFloat() >= 0.0023f) {
                return;
            }
            Material replacement = this.deepMats[this.rnd.nextInt(this.deepMats.length)];
            blockAt.setType(replacement);
            player.sendMessage("\u00a77A new ore just spawned!");
        } else if (blockAt.getType() == Material.NETHERRACK && blockType == Material.NETHERRACK) {
            if (this.rnd.nextFloat() >= 8.0E-4f) {
                return;
            }
            Material replacement = this.netherMats[this.rnd.nextInt(this.netherMats.length)];
            if (replacement == Material.ANCIENT_DEBRIS && this.rnd.nextFloat() >= 0.5f) {
                return;
            }
            blockAt.setType(replacement);
            player.sendMessage("\u00a77A new ore just spawned!");
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForMinersBlessing(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.minersblessing.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.minersblessing.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
        List lore = im.getLore();
        Objects.requireNonNull(this.util);
        int tier = this.parseLevelInt((String)lore.get(5));
        if (tier < 7) {
            return;
        }
        String text = this.getMode(lore);
        if (text.equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Silk Touch")) {
            im.removeEnchant(Enchantment.SILK_TOUCH);
            if (im.getEnchantLevel(Enchantment.EFFICIENCY) == 6) {
                im.addEnchant(Enchantment.FORTUNE, 4, true);
                lore.set(this.util.MINER_INSERTION + 3, "\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Fortune IV");
                player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79Fortune IV");
            } else {
                im.addEnchant(Enchantment.FORTUNE, 3, false);
                lore.set(this.util.MINER_INSERTION + 3, "\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Fortune III");
                player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79Fortune III");
            }
        } else if (tier >= 8 && text.startsWith("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Fortune ")) {
            im.removeEnchant(Enchantment.FORTUNE);
            lore.set(this.util.MINER_INSERTION + 3, "\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Smelting Touch");
            if (tier >= 10) {
                if (im.getEnchantLevel(Enchantment.EFFICIENCY) == 6) {
                    im.addEnchant(Enchantment.FORTUNE, 4, true);
                    player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79Smelting Touch + Fortune IV");
                } else {
                    im.addEnchant(Enchantment.FORTUNE, 3, false);
                    player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79Smelting Touch + Fortune III");
                }
            } else {
                player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79Smelting Touch");
            }
        } else if (tier >= 14 && text.equals("\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Smelting Touch")) {
            im.removeEnchant(Enchantment.FORTUNE);
            lore.set(this.util.MINER_INSERTION + 3, "\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Area Mine");
            player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79\u00a7nArea Mine");
        } else {
            im.removeEnchant(Enchantment.FORTUNE);
            im.addEnchant(Enchantment.SILK_TOUCH, 1, false);
            lore.set(this.util.MINER_INSERTION + 3, "\u00a7a>\u00a7b>\u00a7c> \u00a76Currently set to \u00a79Silk Touch");
            player.sendMessage("\u00a7a>\u00a7b>\u00a7c> \u00a76Pickaxe set to \u00a79Silk Touch");
        }
        im.setLore(lore);
        player.getInventory().getItemInMainHand().setItemMeta(im);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMending(PlayerItemMendEvent event) {
        if (!this.util.checkForMinersBlessing(event.getItem())) {
            return;
        }
        ItemMeta im = event.getItem().getItemMeta();
        List lore = im.getLore();
        Objects.requireNonNull(this.util);
        if (this.parseLevelInt((String)lore.get(5)) >= 12) {
            return;
        }
        if (Math.random() >= 0.14285714285714285) {
            event.setCancelled(true);
        }
    }

    public void regHasteRunnable() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("weaponmaster.minersblessing.use") || !MinerItemListener.this.util.checkForMinersBlessing(player.getInventory().getItemInMainHand())) continue;
                    List lore = player.getInventory().getItemInMainHand().getItemMeta().getLore();
                    Objects.requireNonNull(MinerItemListener.this.util);
                    if (MinerItemListener.this.parseLevelInt((String)lore.get(5)) < 13) continue;
                    player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 200, 0, true));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 60L);
    }

    public void areaBlockBreak(Location loc, final Player player, ItemStack tool, Damageable im, int tier) {
        if (!this.cooldown.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = 3; dy >= -3; --dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    Location newLoc = loc.clone().add((double)dx, (double)dy, (double)dz);
                    Block block = newLoc.getBlock();
                    if (!(0.0f <= block.getType().getHardness()) || !(block.getType().getHardness() <= 3.0f)) continue;
                    if (block.getType() != Material.AIR && Math.random() < 0.025) {
                        im.setDamage(im.getDamage() + 1);
                    }
                    block.breakNaturally(tool);
                }
            }
        }
        this.cooldown.put(player.getUniqueId(), false);
        new BukkitRunnable(){

            public void run() {
                MinerItemListener.this.cooldown.put(player.getUniqueId(), true);
            }
        }.runTaskLater((Plugin)this.plugin, tier >= 15 ? (tier >= 16 ? 300L : 400L) : 500L);
    }
}

