/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.HermesBoots;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HermesItemListener
implements Listener {
    private final double ACTIVATE_CHANCE;
    private final long COOLDOWN_TICKS;
    private Map<UUID, Boolean> cooldown = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public HermesItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.ACTIVATE_CHANCE = plugin.getConfig().getDouble("hermes.activate_chance", 0.12);
        this.COOLDOWN_TICKS = plugin.getConfig().getLong("hermes.cooldown_ticks", 320L);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        final Player player = (Player)event.getEntity();
        if (!this.util.checkForHermesBoots(player.getInventory().getBoots())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.hermesboots.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.hermesboots.use\u00a73.");
            return;
        }
        if (Math.random() < this.ACTIVATE_CHANCE && this.cooldown.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            event.setCancelled(true);
            player.sendMessage("\u00a76You dodged this attack!");
            if (event.getDamager() instanceof Player) {
                ((Player)event.getDamager()).sendMessage("\u00a76Your attack was dodged!");
            }
            this.cooldown.put(player.getUniqueId(), false);
            new BukkitRunnable(){

                public void run() {
                    HermesItemListener.this.cooldown.put(player.getUniqueId(), true);
                }
            }.runTaskLater((Plugin)this.plugin, this.COOLDOWN_TICKS);
        }
    }
}

