/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.HeavyAxe;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class HeavyAxeItemListener
implements Listener {
    private static final List<String> WOODS = List.of("ACACIA_LOG", "BIRCH_LOG", "DARK_OAK_LOG", "JUNGLE_LOG", "OAK_LOG", "SPRUCE_LOG", "WARPED_STEM", "CRIMSON_STEM", "MANGROVE_LOG", "PALE_OAK_LOG");
    private static final List<String> LEAVES = List.of("ACACIA_LEAVES", "BIRCH_LEAVES", "DARK_OAK_LEAVES", "JUNGLE_LEAVES", "OAK_LEAVES", "SPRUCE_LEAVES", "WARPED_WART_BLOCK", "NETHER_WART_BLOCK", "MANGROVE_LEAVES", "PALE_OAK_LEAVES");
    private final WeaponMasterMain plugin;
    private final Util util;

    public HeavyAxeItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    private static boolean isWood(Material mat) {
        return WOODS.contains(mat.name());
    }

    private static boolean isLeaves(Material mat) {
        return LEAVES.contains(mat.name());
    }

    @EventHandler
    public void onTreeBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!this.util.checkForHeavyAxe(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.heavyaxe.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.heavyaxe.use\u00a73.");
            return;
        }
        if (!HeavyAxeItemListener.isWood(event.getBlock().getType()) && !HeavyAxeItemListener.isLeaves(event.getBlock().getType())) {
            return;
        }
        HashSet<Location> visited = new HashSet<Location>();
        LinkedList<Location> locationQueue = new LinkedList<Location>();
        locationQueue.add(event.getBlock().getLocation());
        int woodLeft = 50;
        int leavesLeft = 100;
        while (!(locationQueue.isEmpty() || woodLeft <= 0 && leavesLeft <= 0)) {
            Location newLocation;
            int z;
            int y;
            int x;
            Location currentLocation = (Location)locationQueue.poll();
            if (HeavyAxeItemListener.isWood(currentLocation.getBlock().getType()) && woodLeft > 0) {
                visited.add(currentLocation);
                --woodLeft;
                currentLocation.getBlock().breakNaturally(player.getInventory().getItemInMainHand());
                for (x = -1; x <= 1; ++x) {
                    for (y = -1; y <= 1; ++y) {
                        for (z = -1; z <= 1; ++z) {
                            newLocation = currentLocation.clone().add((double)x, (double)y, (double)z);
                            if (visited.contains(newLocation)) continue;
                            locationQueue.add(newLocation);
                        }
                    }
                }
            }
            if (!HeavyAxeItemListener.isLeaves(currentLocation.getBlock().getType()) || leavesLeft <= 0) continue;
            visited.add(currentLocation);
            --leavesLeft;
            for (x = -1; x <= 1; ++x) {
                for (y = -1; y <= 1; ++y) {
                    for (z = -1; z <= 1; ++z) {
                        newLocation = currentLocation.clone().add((double)x, (double)y, (double)z);
                        if (newLocation.getBlock().getType() != currentLocation.getBlock().getType() && !HeavyAxeItemListener.isWood(newLocation.getBlock().getType()) || visited.contains(newLocation)) continue;
                        locationQueue.add(newLocation);
                    }
                }
            }
            currentLocation.getBlock().breakNaturally(player.getInventory().getItemInMainHand());
        }
    }
}

