/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.EndSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EndPowerManager {
    private final Map<Player, Integer> powerMap = new HashMap<Player, Integer>();
    private final Util util = new Util(null);

    public int getPower(Player player) {
        return this.powerMap.getOrDefault(player, this.getMaxPower(player));
    }

    public void incrementPower(Player player, int by) {
        this.powerMap.put(player, Math.min(Math.max(this.getPower(player) + by, 0), this.getMaxPower(player)));
    }

    public int getMaxPower(Player player) {
        int pearlsThrown = player.getStatistic(Statistic.USE_ITEM, Material.ENDER_PEARL);
        int armorBonus = 0;
        for (ItemStack armorPiece : player.getInventory().getArmorContents()) {
            if (!this.util.checkForEndArmor(armorPiece)) continue;
            armorBonus += 50;
        }
        return 150 + Math.min(pearlsThrown / 100, 30) + armorBonus;
    }

    public void registerEndPowerManagerTask(final WeaponMasterMain plugin) {
        final int ticksPer = 5;
        new BukkitRunnable(){
            int tickCounter = 0;

            public void run() {
                this.tickCounter += ticksPer;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!EndPowerManager.this.util.checkForEndSword(player.getInventory().getItemInMainHand())) continue;
                    int power = EndPowerManager.this.getPower(player);
                    int maxPower = EndPowerManager.this.getMaxPower(player);
                    boolean sendAnyway = this.tickCounter % 100 == 0;
                    plugin.paperUtils.sendActionBar(player, String.format("\u00a7f%d \u00a77/ \u00a7f%d \u00a7dEnd Power", power, maxPower), sendAnyway);
                }
                if (this.tickCounter % 80 == 0) {
                    for (Player player : EndPowerManager.this.powerMap.keySet()) {
                        EndPowerManager.this.incrementPower(player, EndPowerManager.this.getMaxPower(player) / 10);
                    }
                }
            }
        }.runTaskTimer((Plugin)plugin, (long)ticksPer, (long)ticksPer);
    }
}

