/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DeathScythe;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.TrueDamageHelper;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class ScytheItemListener
implements Listener {
    private final Map<UUID, Boolean> cooldowns = new HashMap<UUID, Boolean>();
    private final double DAMAGE_RATIO;
    private final Util util;
    private final WeaponMasterMain plugin;
    private final int DURABILITY_THRESHOLD = 249;

    public ScytheItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.DAMAGE_RATIO = plugin.getConfig().getDouble("deathScythe.damage_ratio", 0.3);
    }

    private int getStrengthLevel(double damageAmount) {
        if (damageAmount >= this.plugin.getConfig().getDouble("deathScythe.strength5Threshold")) {
            return 4;
        }
        if (damageAmount >= this.plugin.getConfig().getDouble("deathScythe.strength4Threshold")) {
            return 3;
        }
        if (damageAmount >= this.plugin.getConfig().getDouble("deathScythe.strength3Threshold")) {
            return 2;
        }
        if (damageAmount >= this.plugin.getConfig().getDouble("deathScythe.strength2Threshold")) {
            return 1;
        }
        return 0;
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        final Player player = (Player)event.getDamager();
        if (!this.util.checkForDeathScythe(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.deathscythe.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.deathscythe.use\u00a73.");
            return;
        }
        if (!this.cooldowns.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        this.cooldowns.put(player.getUniqueId(), false);
        ItemStack scythe = player.getInventory().getItemInMainHand();
        Damageable iMeta = (Damageable)scythe.getItemMeta();
        if (iMeta.getDamage() >= 249) {
            player.sendMessage("\u00a73Not enough durability!");
            return;
        }
        iMeta.setDamage(iMeta.getDamage() + 26);
        if (iMeta.getDamage() > 249) {
            iMeta.setDamage(249);
        }
        scythe.setItemMeta((ItemMeta)iMeta);
        LivingEntity target = (LivingEntity)event.getEntity();
        double damageAmount = (target.getHealth() + target.getAbsorptionAmount()) * this.DAMAGE_RATIO;
        TrueDamageHelper.dealTrueDamage(target, damageAmount);
        int strengthLevel = this.getStrengthLevel(damageAmount);
        player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 300, strengthLevel, true));
        player.sendMessage(String.format("\u00a73Dealt \u00a74%.1f \u00a73damage. You gained \u00a7bStrength \u00a7c%d\u00a73 for \u00a7b15 \u00a73seconds.", damageAmount, strengthLevel + 1));
        long cooldown = this.plugin.getConfig().getLong("deathScythe.cooldownTicks", 10L);
        if (cooldown > 0L) {
            new BukkitRunnable(){

                public void run() {
                    ScytheItemListener.this.cooldowns.put(player.getUniqueId(), true);
                }
            }.runTaskLater((Plugin)this.plugin, cooldown);
        } else {
            this.cooldowns.put(player.getUniqueId(), true);
        }
    }

    @EventHandler
    public void onMending(PlayerItemMendEvent event) {
        if (this.util.checkForDeathScythe(event.getItem())) {
            event.getPlayer().sendMessage("\u00a76You can't mend this item.");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        ItemStack scythe = event.getInventory().getItem(0);
        ItemStack sacrificeItem = event.getInventory().getItem(1);
        if (!this.util.checkForDeathScythe(scythe)) {
            return;
        }
        if (sacrificeItem != null) {
            event.setResult(null);
            ((HumanEntity)event.getViewers().get(0)).sendMessage("\u00a7cYou can't use this in an anvil!");
        }
    }
}

