/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.AssaultRifle;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.AssaultRifle.AssaultRifleMode;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class AssaultListener
implements Listener {
    private final Map<UUID, AssaultRifleMode> modes = new HashMap<UUID, AssaultRifleMode>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public AssaultListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    private void fireOneRound(Player player, ItemStack rifle) {
        Location eyeLoc = player.getEyeLocation();
        Vector velocityVector = eyeLoc.getDirection().multiply(46.3);
        Arrow arrow = (Arrow)player.getWorld().spawnEntity(eyeLoc, EntityType.ARROW);
        arrow.setDamage(7.0);
        arrow.setKnockbackStrength(3);
        arrow.setVelocity(velocityVector);
        arrow.setShooter((ProjectileSource)player);
        player.getWorld().spawnParticle(Particle.SMALL_FLAME, eyeLoc, 20, 0.0, 0.0, 0.0, 0.001);
        player.playSound((Entity)player, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        this.setBulletsRemaining(rifle, this.getBulletsRemaining(rifle) - 1);
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.util.checkForAssaultRifle(event.getBow())) {
            event.setCancelled(true);
        }
    }

    public int getBulletsRemaining(ItemStack rifle) {
        PersistentDataContainer pdc = rifle.getItemMeta().getPersistentDataContainer();
        Integer amount = (Integer)pdc.get(new NamespacedKey((Plugin)this.plugin, "loaded"), PersistentDataType.INTEGER);
        if (amount == null) {
            return 0;
        }
        return amount;
    }

    public void setBulletsRemaining(ItemStack rifle, int amount) {
        ItemMeta im = rifle.getItemMeta();
        PersistentDataContainer pdc = im.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this.plugin, "loaded"), PersistentDataType.INTEGER, (Object)amount);
        rifle.setItemMeta(im);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForAssaultRifle(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.assaultrifle.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.assaultrifle.use\u00a73.");
            return;
        }
        final ItemStack rifle = player.getInventory().getItemInMainHand();
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            switch (this.modes.getOrDefault(player.getUniqueId(), AssaultRifleMode.SINGLE_SHOT)) {
                case SINGLE_SHOT: {
                    if (this.getBulletsRemaining(rifle) >= 1) {
                        player.setVelocity(player.getVelocity().subtract(player.getEyeLocation().getDirection().multiply(0.03)));
                        this.fireOneRound(player, rifle);
                        break;
                    }
                    player.sendMessage("\u00a77No rounds loaded!");
                    break;
                }
                case BURST: {
                    new BukkitRunnable(){
                        int i = 0;

                        public void run() {
                            if (this.i >= 5) {
                                this.cancel();
                                return;
                            }
                            if (AssaultListener.this.getBulletsRemaining(rifle) < 1) {
                                player.sendMessage("\u00a77No rounds loaded!");
                                this.cancel();
                                return;
                            }
                            player.setVelocity(player.getVelocity().subtract(player.getEyeLocation().getDirection().multiply(0.03)));
                            AssaultListener.this.fireOneRound(player, rifle);
                            ++this.i;
                        }
                    }.runTaskTimer((Plugin)this.plugin, 1L, 2L);
                    break;
                }
                default: {
                    player.sendMessage("\u00a77not implemented");
                    break;
                }
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) {
            if (player.isSneaking()) {
                player.sendMessage("\u00a77Reloading!");
                if (this.getBulletsRemaining(rifle) == -1) {
                    player.sendMessage("\u00a7cCan't reload while another reload is taking place!");
                } else {
                    this.setBulletsRemaining(rifle, -1);
                    new BukkitRunnable(){

                        public void run() {
                            int amount = 64;
                            AssaultListener.this.setBulletsRemaining(rifle, amount);
                            player.sendMessage("\u00a7cReloaded!");
                        }
                    }.runTaskLater((Plugin)this.plugin, 20L);
                }
            } else {
                AssaultRifleMode currentMode = this.modes.getOrDefault(player.getUniqueId(), AssaultRifleMode.SINGLE_SHOT);
                if (currentMode == AssaultRifleMode.SINGLE_SHOT) {
                    this.modes.put(player.getUniqueId(), AssaultRifleMode.BURST);
                    player.sendMessage("\u00a73Set to burst!");
                } else if (currentMode == AssaultRifleMode.BURST) {
                    this.modes.put(player.getUniqueId(), AssaultRifleMode.SINGLE_SHOT);
                    player.sendMessage("\u00a73Set to single shot!");
                }
            }
        }
    }
}

